// Given a destination object and any number of source objects, forward
// every property from the source objects to the destination. This is
// similar to _.extend but any functions, getters, or setters are copied
// with `this` bound to the source object.
export function forwardProperties(dest) {
    Array.prototype.slice.call(arguments, 1).forEach(function(source) {
        if (!source) {
            return;
        }

        for (var prop in source) {
            var descriptor = Object.getOwnPropertyDescriptor(source, prop);

            if (descriptor.get) {
                descriptor.get = descriptor.get.bind(source);
            }

            if (descriptor.set) {
                descriptor.set = descriptor.set.bind(source);
            }

            if (typeof descriptor.value === 'function') {
                descriptor.value = descriptor.value.bind(source);
            }

            Object.defineProperty(dest, prop, descriptor);
        }
    });

    return dest;
}
