export class IntervalTimer {
    constructor(callback, interval, windowObj) {
        this.interval = interval;
        this.callback = callback;
        this.windowObj = windowObj;
        this.timerId = 0;
        this.lastStartTimestamp = 0;
        this.intervalRemaining = this.interval;
    }

    start() {
        if (this.timerId !== 0) {
            return;
        }

        this.lastStartTimestamp = Date.now();
        this.timerId = this.windowObj.setTimeout(() => this.timeoutCallback(), this.intervalRemaining);
    }

    pause() {
        if (this.timerId === 0) {
            return;
        }

        this.windowObj.clearTimeout(this.timerId);
        const currentTime = Date.now();
        this.intervalRemaining = this.intervalRemaining - (currentTime - this.lastStartTimestamp);
        this.timerId = 0;
    }

    timeoutCallback() {
        this.callback();
        this.restartTimer();
    }

    restartTimer() {
        this._reset();
        this.start();
    }

    _reset() {
        this.windowObj.clearTimeout(this.timerId);
        this.timerId = 0;
        this.lastStartTimestamp = 0;
        this.intervalRemaining = this.interval;
    }

    destroy() {
        this.windowObj.clearTimeout(this.timerId);
    }
}
