import BigScreen from 'bigscreen/bigscreen';
import { setCanFullScreen } from '../actions/screen-mode';

export const FULLSCREEN_CHANGE = 'fullscreenchange';

/**
 * No Fullscreen Utility
 * Surfaces the functionality where fullscreening capabilities are off for the player.
 * @class
 */
export class NoFullScreen {
    /**
     * @constructor
     */
    constructor(root, store) {
        this._store = store;
        this._root = root;
        this._store.dispatch(setCanFullScreen(this.canFullScreen()));
    }

    /**
     * Checks if player is able to fullscreen.
     * @return {Boolean}
     */
    canFullScreen() {
        return false;
    }

    /**
     * Checks if player is fullscreen
     * @return {Boolean}
     */
    isFullScreen() {
        return BigScreen.element === this._root;
    }
}
