/* global Twitch */
import { isTwitchEmbed } from './twitch-embed';

export const PLAYER_SITE = 'site';
export const PLAYER_SITE_MINI = 'site_mini';
export const PLAYER_EMBED = 'embed';
export const PLAYER_POPOUT = 'popout';
export const PLAYER_ANIMATED_THUMBNAILS = 'animated_thumbnails';
export const PLAYER_FRONTPAGE = 'frontpage';
export const PLAYER_DASHBOARD = 'dashboard';
export const PLAYER_CREATIVE = 'creative';
export const PLAYER_CURSE = 'curse';
export const PLAYER_FACEBOOK = 'facebook';
export const PLAYER_HIGHLIGHTER = 'highlighter';
export const PLAYER_TWITCH_EVERYWHERE = 'twitch_everywhere';
export const PLAYER_PULSE = 'pulse';
export const PLAYER_IMDB = 'imdb';
export const PLAYER_AMAZON_LIVE = 'amazon_live';
export const PLAYER_CLIPS_VIEWING = 'clips-viewing';
export const PLAYER_CLIPS_EMBED = 'clips-embed';
export const PLAYER_CLIPS_EDITING = 'clips-editing';
export const PLAYER_AMAZON_VSE = 'amazon_vse_test';
export const PLAYER_FEED = 'feed';

export const CLIPS_PLAYER_TYPES = [PLAYER_CLIPS_VIEWING, PLAYER_CLIPS_EMBED, PLAYER_CLIPS_EDITING];
export const ALL_PLAYER_TYPES = [
    PLAYER_SITE,
    PLAYER_SITE_MINI,
    PLAYER_EMBED,
    PLAYER_POPOUT,
    PLAYER_ANIMATED_THUMBNAILS,
    PLAYER_FRONTPAGE,
    PLAYER_DASHBOARD,
    PLAYER_CREATIVE,
    PLAYER_CURSE,
    PLAYER_FACEBOOK,
    PLAYER_HIGHLIGHTER,
    PLAYER_TWITCH_EVERYWHERE,
    PLAYER_PULSE,
    PLAYER_IMDB,
    PLAYER_AMAZON_LIVE,
    PLAYER_CLIPS_VIEWING,
    PLAYER_CLIPS_EMBED,
    PLAYER_CLIPS_EDITING,
    PLAYER_AMAZON_VSE,
    PLAYER_FEED,
];

/**
 * Determine if the player is running in an iframe.
 *
 * @return {Boolean}
 */
export function isEmbed() {
    try {
        return window.self !== window.top;
    } catch (e) {
        // Access was denied, which means we are an iframe.
        return true;
    }
}

/**
 * Deduce the type of the player from the context of the page.
 *
 * @return {String}
 */
export function getPlayerType() {
    // Weird name, but only good way of detecting our include mode.
    var isScript = !Twitch.notScript;

    if (isScript) {
        return PLAYER_SITE;
    } else if (isEmbed() && !isTwitchEmbed()) {
        return PLAYER_EMBED;
    }
    return PLAYER_POPOUT;
}
