import { CONTENT_MODE_LIVE } from 'stream/twitch-live';
import { CONTENT_MODE_VOD } from 'stream/twitch-vod';
import { playerHost, popoutSize } from '../settings';
import * as Params from './params';
import * as Timestamp from './timestamp';
import { PLAYER_IMDB } from './player-type';

export function popoutPlayer({
    collection,
    playback,
    playerType,
    stream,
    window: windowObj,
}) {
    const options = {
        volume: playback.volume,
        muted: playback.muted,
    };

    if (stream.contentType === CONTENT_MODE_VOD) {
        options.video = stream.videoId;
        options.collection = collection ? collection.id : undefined;
        options.time = Timestamp.toURLString(playback.currentTime);
    } else if (stream.contentType === CONTENT_MODE_LIVE) {
        options.channel = stream.channel;
    }

    // If playerType is IMDb, maintain it in popout
    if (playerType === PLAYER_IMDB) {
        options.player = PLAYER_IMDB;
    }

    const url = `${playerHost}/?${Params.toString(options)}`;

    // Defaults to 480p
    const { height, width } = popoutSize;
    // note: The address bar will still show if the origin is different.
    const args = `width=${width},height=${height},toolbar=no,menubar=no,scrollbars=no,location=no,status=no`;

    // note: The popout uses the embed API to control the player.
    windowObj.open(url, '_blank', args);
}
