/**
 * Compute the statistical properties of a set of data points; specifically, the
 * mean and the standard deviation.
 *
 * @param {Array<Number>} pts
 * @return {{mean: Number, stdev: Number}}
 */
export function getStats(pts) {
    var mean = pts.reduce(function(sum, pt) {
        return sum + pt;
    }, 0) / (pts.length);

    var variance = pts.reduce(function(sumOfSquares, pt) {
        return sumOfSquares + Math.pow(pt - mean, 2);
    }, 0) / (pts.length);

    var stdev = Math.sqrt(variance);

    return {
        mean: mean,
        stdev: stdev,
    };
}
