import { parseUri } from './parseuri';

export const twitchDomain = 'twitch.tv';
export const twitchTechDomain = 'twitch.tech';

function getHost() {
    // Get the window or referral url.
    if (window.self !== window.parent) {
        return document.referrer;
    }

    return window.location.href;
}

// Returns true if we are embedded or running on twitch.tv
export function isTwitchEmbed(url = getHost()) {
    const uri = parseUri(url);

    // Get the last two parts of the domain.
    // TODO Move this into another library.
    const topLevelHost = uri.host.split('.').slice(-2).join('.');

    // Make sure we're a subdomain of twitch.tv or twitch.tech, for Twilight QA purposes
    return topLevelHost === twitchDomain || topLevelHost === twitchTechDomain;
}

export function isDesktopApp(url) {
    return parseUri(url).host === '127.0.0.1';
}
