import isString from 'lodash/isString';
import { parse, toString } from './params';

export const DEFAULT_PARAMS_BLACKLIST = Object.freeze([
    'oauth_token',
]);

/**
 * Processes a query string and removes all parameters keys.
 *
 * @param {String} str - a URL or query string
 * @param {String[]} queryParams - the keys to delete
 *
 * @returns {String} the sanitized string
 */
export function sanitizeQuery(str, queryParams = DEFAULT_PARAMS_BLACKLIST) {
    const isArray = Array.isArray(queryParams) && queryParams.length > 0;
    if (!isString(str) || !isArray) {
        return str;
    }

    const queryIndex = str.indexOf('?');
    const url = str.slice(0, queryIndex);
    const query = (queryIndex < 0 ? '' : str.slice(queryIndex + 1));

    if (query.length > 0) {
        const params = parse(query);
        queryParams.forEach(key => delete params[key]);
        return `${url}?${toString(params)}`;
    }
    return str;
}
