/* global module, __dirname */
// TODO define a correct eslintrc that recognizes this file as a Node module
var converter = require('i18next-conv');
var path = require('path');

module.exports = function(grunt) {
    grunt.config.requires('localization');

    grunt.loadNpmTasks('grunt-smartling-sdk');

    var conf = grunt.config.get('localization');
    grunt.config.merge({
        smartling_get: { // eslint-disable-line camelcase
            options: {
                smartling: conf.options,
                operation: conf.operation.get,
                fileUriFunc() {
                    return 'strings.pot';
                },
                destFileUriFunc() {
                    return 'strings.po';
                },
                verbose: true,
            },
            array: {
                locales: conf.locales,
                src: path.resolve(__dirname, '../localization/strings.pot'),
                dest: path.resolve(__dirname, '../localization'),
            },
        },
        smartling_upload: { // eslint-disable-line camelcase
            options: {
                smartling: conf.options,
                operation: conf.operation.upload,
                fileUriFunc(filepath) {
                    return path.basename(filepath);
                },
            },
            one: {
                src: 'localization/strings.pot',
            },
        },
    });

    grunt.registerTask(
        'i18n',
        'Upload & retrieve translations for this project',
        [
            'smartling_upload',
            'smartling_get',
            'po-to-json',
        ]
    );

    grunt.registerTask('po-to-json', 'Task to convert .po files to .json', function() {
        var done = this.async();
        var locales = grunt.config.get('localization.locales');

        var localePromises = locales.map(function(locale) {
            var source = `localization/${locale}/strings.po`;
            var target = `localization/${locale}/strings.json`;

            return new Promise(resolve => {
                converter.gettextToI18next(locale, source, target, {
                    quiet: true,
                    filter(gt, domain, callback) {
                        grunt.log.write(`Converting locale ${domain}... `);

                        var domainObject = gt.domains[gt._normalizeDomain(domain)];

                        if (domain === 'en-US') {
                            var translations = domainObject.translations[''];
                            Object.keys(translations).forEach(function(key) {
                                translations[key].msgstr = [translations[key].msgid];
                                if (translations[key].hasOwnProperty('msgid_plural')) {
                                    translations[key].msgstr.push(translations[key].msgid_plural);
                                }
                            });
                        }

                        grunt.log.ok();

                        callback(null, domainObject.translations);
                    },
                }, resolve);
            });
        });

        Promise.all(localePromises).then(done, done);
    });
};
