const BigScreen = {
    element: null,
    enabled: true,
    _isFullScreen: false,
    toggle(root, onFullscreenStart, onFullscreenEnd) {
        this.root = root;
        if (this._isFullScreen) {
            this.element = null;
            onFullscreenEnd();
            this._isFullScreen = false;
        } else {
            this.element = root;
            onFullscreenStart();
            this._isFullScreen = true;
        }
    },
    onchange: () => {},
    _reset: () => {
        this.root = null;
        this._isFullScreen = false;
        this.enabled = true;
        this.element = null;
        this.onchange = () => {};
    },
};

document.addEventListener('fullscreenchange', function() {
    BigScreen.onchange();
});

export default BigScreen;
