import sinon from 'sinon';

class ExtensionService {
    constructor() {
        this.getInstalledExtensions = sinon.stub();
        this.subscribeToExtensionControl = () => {};
        this.registerPlayer = sinon.stub();
        this.unregisterPlayer = sinon.stub();
        this.listenForContext = sinon.stub();
        this.postContext = sinon.stub();
    }
}

export class ExtensionFrame {
    constructor(params) {
        const options = params || {};

        this.destroy = sinon.stub();
        this.on = sinon.stub();
        this.off = sinon.stub();
        this.linkIdentity = sinon.stub();
        this.unlinkIdentity = sinon.stub();

        this.extension = options.extension;
        this.mode = options.mode;
        this.language = options.language;
        this.locale = options.locale;
    }
}

export const ExtensionCoordinator = {
    ExtensionService: new ExtensionService(),
    ExtensionFrame: ExtensionFrame,
};
