class LocalStoreFake {
    constructor() {
        this._cache = {};
    }

    get(key, defaultValue) {
        if (this._cache.hasOwnProperty(key)) {
            try {
                return JSON.parse(this._cache[key]);
            } catch (e) {
                // ignore and return the default value
            }
        }
        return defaultValue;
    }

    has(key) {
        return this._cache.hasOwnProperty(key);
    }

    set(key, value) {
        this._cache[key] = JSON.stringify(value);
    }

    remove(key) {
        delete this._cache[key];
    }

    clear() {
        this._cache = {};
    }
}

export const localStore = new LocalStoreFake();
export const sessionStore = new LocalStoreFake();
