import PlayerCore from './playercore.fake.js';
import MediaPlayer from './mediaplayer.fake.js';

const PlayerCoreLoader = {
    load() {
        return new Promise(this._runNext);
    },
    loadMediaPlayer() {
        return new Promise(this._runNextMediaPlayer);
    },
    canLoad() {
        return true;
    },
    canLoadMediaplayer() {
        return true;
    },
    _runNext(resolve) {
        setTimeout(() => resolve({
            handle: PlayerCore,
            config: {},
        }), 1);
    },
    _runNextMediaPlayer(resolve) {
        setTimeout(() => resolve({
            mediaPlayerInstance: new MediaPlayer(),
            mediaPlayerHandle: MediaPlayer,
        }), 1);
    },
};

export default PlayerCoreLoader;
