export class FakePlayer {
    constructor(options = {}) {
        this.isPlaying = options.isPlaying || false;
        this.isPaused = options.isPaused || false;
        this.isMuted = options.isMuted || false;
        this.listeners = {};
    }

    addEventListener(eventName, handler) {
        if (this.listeners[eventName]) {
            this.listeners[eventName].push(handler);
        } else {
            this.listeners[eventName] = [handler];
        }
    }

    _triggerEvent(eventName) {
        this.listeners[eventName].forEach(function(handler) {
            handler();
        });
    }

    play() {
        this.isPlaying = true;
        this.isPaused = false;
    }

    pause() {
        this.isPlaying = false;
        this.isPaused = true;
    }

    setMuted(isMuted) {
        this.isMuted = isMuted;
    }
}
