import sinon from 'sinon';
import { DEFAULT_STATS } from 'state/stats';

class PlayerCore {
    constructor() {
        this.eventHandlers = {};
        this.stats = DEFAULT_STATS;
        this.videoInfo = {};
        sinon.spy(this, 'addEventListener');
    }

    addEventListener(name, handler) {
        if (this.eventHandlers[name]) {
            this.eventHandlers[name].push(handler);
        } else {
            this.eventHandlers[name] = [handler];
        }
    }

    removeEventListener(name, removeHandler) {
        if (removeHandler) {
            this.eventHandlers[name] = this.eventHandlers[name].filter(handler => handler !== removeHandler);
        } else {
            this.eventHandlers[name] = [];
        }
    }

    attachMedia(element) {
        this.media = element;
    }

    // Used only for testing. Not available in player-core
    emit(name, data) {
        const handlers = this.eventHandlers[name];
        handlers.forEach(handler => handler(data));
    }

    loadURL() {}

    _setPlaybackStatistics(stats) {
        this.stats = stats;
    }

    _setVideoInfo(videoInfo) {
        this.videoInfo = videoInfo;
    }

    getPlaybackStatistics() {
        return this.stats;
    }

    setQuality(quality) {
        this.quality = quality;
    }

    getQuality() {
        return this.quality;
    }

    getVideoInfo() {
        return this.videoInfo;
    }

    stop() {}

    destroy() {}

    getVersion() {
        return 'v1.0.0';
    }

    paused() {
        return this.media.paused;
    }

    ended() {
        return this.media.ended;
    }

    play() {
        return this.media.play();
    }

    pause() {
        return this.media.pause();
    }
}

PlayerCore.Event = {
    HLS_MASTER_PARSED: 'hlsmanifestparsed',
    HLS_VARIANT_PARSED: 'hlsvariantparsed',
    VARIANT_SWITCH_REQUESTED: 'renditionswitchrequested',
    SEGMENT_CHANGED: 'segmentchange',
    SPLICEOUT: 'spliceout',
    SPLICEIN: 'splicein',
    CAPTION: 'caption',
    AUTH_ERROR: 'autherror',
    CORE_ANALYTICS: 'coreanalytics',
    OFFLINE: 'offline',
    BUFFERING: 'buffering',
    FATAL_ERROR: 'fatal_error',
};

export default PlayerCore;
