import { EVENT_ONLINE, EVENT_OFFLINE } from 'pubsub';
import EventEmitter from 'event-emitter';
import { init as initStore } from 'state';
import { setOnline } from 'actions/online';

export const EVENT_STATE_UPDATE = 'stateupdate';

export class FakeState {
    constructor() {
        this._eventEmitter = new EventEmitter();
        this._store = initStore();
    }

    addEventListener(event, callback) {
        this._eventEmitter.addListener(event, callback);
    }

    handleEvent(event) {
        switch (event) {
        case EVENT_ONLINE:
            this._store.dispatch(setOnline(true));
            break;
        case EVENT_OFFLINE:
            this._store.dispatch(setOnline(false));
            break;
        }
        this._eventEmitter.emit(EVENT_STATE_UPDATE, this);
    }
}
