import sinon from 'sinon';
import merge from 'lodash/assign';

import { FakeGoogle } from './google.fake.js';

export function buildFakeWindow(customization) {
    return merge(
        {},
        {
            addEventListener: sinon.spy(),
            google: new FakeGoogle(),
            document: {
                createElement() {
                    return window.document.createElement('div');
                },
            },
            clearTimeout: sinon.spy(),
            setTimeout: sinon.spy(delayedFn => {
                delayedFn();
                return Math.floor(Math.random() * 999);
            }),
            clearInterval: sinon.spy(),
            setInterval: sinon.spy(delayedFn => {
                delayedFn();
                return Math.floor(Math.random() * 999);
            }),
            location: {
                search: '',
            },
            open: sinon.spy(),
            navigator: {
                userAgent: '',
            },
        },
        customization
    );
}
