import { apiHost as API_HOST } from 'settings';

const VOD_ENDPOINT = `${API_HOST}/kraken/channels/lirik/videos`;
const CDN_ENDPOINT = 'https://static-cdn.jtvnw.net/v1/AUTH_system/';
/* eslint-disable camelcase, indent */
export const V3_VIDEOS_RESPONSE = {
    _total: 1986,
    _links: {
        self: `${VOD_ENDPOINT}?broadcast_type=archive&limit=15&offset=0&user=lirik`,
        next: `${VOD_ENDPOINT}?broadcast_type=archive&limit=15&offset=15&user=lirik`,
    },
    videos: [{
        title: 'Video Games - Twitter: LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 22054963392,
        broadcast_type: 'archive',
        status: 'recording',
        tag_list: '',
        views: 366,
        created_at: '2016-06-27T16:02:56Z',
        url: 'https://www.twitch.tv/lirik/v/74837329',
        _id: 'v74837329',
        recorded_at: '2016-06-27T16:02:33Z',
        game: 'Town of Salem',
        length: 9770.612553143,
        preview: `${CDN_ENDPOINT}vods_4538/lirik_22054963392_476184335/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_4538/lirik_22054963392_476184335/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            chunked: 60.0,
            high: 30.0625,
            low: 30.0625,
            medium: 30.0625,
            mobile: 30.0625,
        },
        resolutions: {
            chunked: '1280x720',
            high: '1280x720',
            low: '640x360',
            medium: '852x480',
            mobile: '400x226',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v74837329`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'Sewb Sewnday - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 22039247328,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 12221,
        created_at: '2016-06-26T16:03:14Z',
        url: 'https://www.twitch.tv/lirik/v/74657627',
        _id: 'v74657627',
        recorded_at: '2016-06-26T16:02:51Z',
        game: 'Dead by Daylight',
        length: 26039,
        preview: `${CDN_ENDPOINT}vods_16e0/lirik_22039247328_475689695/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_16e0/lirik_22039247328_475689695/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_16e0/lirik_22039247328_475689695/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_16e0/lirik_22039247328_475689695/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_16e0/lirik_22039247328_475689695/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            chunked: 59.7639736411043,
            high: 29.8877856731781,
            low: 29.8879392851682,
            medium: 29.8877856731781,
            mobile: 29.8879392851682,
        },
        resolutions: {
            chunked: '1280x720',
            high: '1280x720',
            low: '640x360',
            medium: '852x480',
            mobile: '400x226',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v74657627`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'Just Streamin - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 22022399536,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 11306,
        created_at: '2016-06-25T16:05:40Z',
        url: 'https://www.twitch.tv/lirik/v/74462368',
        _id: 'v74462368',
        recorded_at: '2016-06-25T16:05:17Z',
        game: 'Arma 3',
        length: 14916,
        preview: `${CDN_ENDPOINT}vods_2933/lirik_22022399536_475158426/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_2933/lirik_22022399536_475158426/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_2933/lirik_22022399536_475158426/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_2933/lirik_22022399536_475158426/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_2933/lirik_22022399536_475158426/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            chunked: 59.9651348891235,
            high: 29.9836735711759,
            low: 29.9840087610589,
            medium: 29.9836735711759,
            mobile: 29.9840087610589,
        },
        resolutions: {
            chunked: '1280x720',
            high: '1280x720',
            low: '640x360',
            medium: '852x480',
            mobile: '400x226',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v74462368`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'Frack It Friday - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 22005752288,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 33091,
        created_at: '2016-06-24T16:07:49Z',
        url: 'https://www.twitch.tv/lirik/v/74266505',
        _id: 'v74266505',
        recorded_at: '2016-06-24T16:07:26Z',
        game: 'Battlefield: Bad Company 2',
        length: 28292,
        preview: `${CDN_ENDPOINT}vods_004a/lirik_22005752288_474628454/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_004a/lirik_22005752288_474628454/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_004a/lirik_22005752288_474628454/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_004a/lirik_22005752288_474628454/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_004a/lirik_22005752288_474628454/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            chunked: 60.0000014137945,
            high: 29.9998946723511,
            low: 30.0000713965947,
            medium: 29.9998946723511,
            mobile: 30.0000713965947,
        },
        resolutions: {
            chunked: '1280x720',
            high: '1280x720',
            low: '640x360',
            medium: '852x480',
            mobile: '400x226',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v74266505`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'Playing Video Games - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 21974471824,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 18697,
        created_at: '2016-06-22T16:05:25Z',
        url: 'https://www.twitch.tv/lirik/v/73888453',
        _id: 'v73888453',
        recorded_at: '2016-06-22T16:05:02Z',
        game: 'Duck Game',
        length: 27692,
        preview: `${CDN_ENDPOINT}vods_f6c1/lirik_21974471824_473621777/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_f6c1/lirik_21974471824_473621777/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_f6c1/lirik_21974471824_473621777/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_f6c1/lirik_21974471824_473621777/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_f6c1/lirik_21974471824_473621777/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            chunked: 59.9966770926716,
            high: 29.9984288231052,
            low: 29.9984288231052,
            medium: 29.9984288231052,
            mobile: 29.9984288231052,
        },
        resolutions: {
            chunked: '1280x720',
            high: '1280x720',
            low: '640x360',
            medium: '852x480',
            mobile: '400x226',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v73888453`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'GAMIN - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 21958569168,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 15811,
        created_at: '2016-06-21T16:17:54Z',
        url: 'https://www.twitch.tv/lirik/v/73695032',
        _id: 'v73695032',
        recorded_at: '2016-06-21T16:17:31Z',
        game: 'Battlefield: Bad Company 2',
        length: 26365,
        preview: `${CDN_ENDPOINT}vods_e5fb/lirik_21958569168_473109101/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_e5fb/lirik_21958569168_473109101/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_e5fb/lirik_21958569168_473109101/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_e5fb/lirik_21958569168_473109101/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_e5fb/lirik_21958569168_473109101/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 29.9937437572691,
            mobile: 29.9937437572691,
            high: 29.9937437572691,
            low: 29.9937437572691,
            chunked: 59.9863117429428,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v73695032`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'Next Stream: Monday @ NOON EST / 5pm GMT ',
        description: null,
        broadcast_id: 21942634992,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 12787,
        created_at: '2016-06-20T16:12:17Z',
        url: 'https://www.twitch.tv/lirik/v/73509848',
        _id: 'v73509848',
        recorded_at: '2016-06-20T16:11:55Z',
        game: 'Gaming Talk Shows',
        length: 25827,
        preview: `${CDN_ENDPOINT}vods_dc00/lirik_21942634992_472596299/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_dc00/lirik_21942634992_472596299/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_dc00/lirik_21942634992_472596299/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_dc00/lirik_21942634992_472596299/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_dc00/lirik_21942634992_472596299/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 30.0000003871883,
            mobile: 30.0000003871883,
            high: 30.0000003871883,
            low: 30.0000003871883,
            chunked: 60.0000394931972,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v73509848`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'Sewb Sewnday - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 21928200128,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 19300,
        created_at: '2016-06-19T16:14:08Z',
        url: 'https://www.twitch.tv/lirik/v/73342535',
        _id: 'v73342535',
        recorded_at: '2016-06-19T16:13:45Z',
        game: 'Rust',
        length: 23686,
        preview: `${CDN_ENDPOINT}vods_b35e/lirik_21928200128_472131993/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_b35e/lirik_21928200128_472131993/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_b35e/lirik_21928200128_472131993/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_b35e/lirik_21928200128_472131993/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_b35e/lirik_21928200128_472131993/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 30.0000641726148,
            mobile: 30.0000641726148,
            high: 30.0000641726148,
            low: 30.0000641726148,
            chunked: 60.000001688753,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v73342535`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'DA STREMZ - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 21911369648,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 13278,
        created_at: '2016-06-18T16:03:32Z',
        url: 'https://www.twitch.tv/lirik/v/73150249',
        _id: 'v73150249',
        recorded_at: '2016-06-18T16:03:09Z',
        game: 'Gaming Talk Shows',
        length: 26166,
        preview: `${CDN_ENDPOINT}vods_7c66/lirik_21911369648_471589284/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_7c66/lirik_21911369648_471589284/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_7c66/lirik_21911369648_471589284/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_7c66/lirik_21911369648_471589284/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_7c66/lirik_21911369648_471589284/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 29.9766319718822,
            mobile: 29.9766319718822,
            high: 29.9766319718822,
            low: 29.9766319718822,
            chunked: 59.9508945425782,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v73150249`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        // eslint-disable-next-line quotes
        title: "Pretend I'm Not Here",
        description: null,
        broadcast_id: 21903603376,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 9535,
        created_at: '2016-06-18T02:53:48Z',
        url: 'https://www.twitch.tv/lirik/v/73062054',
        _id: 'v73062054',
        recorded_at: '2016-06-18T02:53:25Z',
        game: 'Worms Reloaded',
        length: 10242,
        preview: `${CDN_ENDPOINT}vods_aaee/lirik_21903603376_471338846/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_aaee/lirik_21903603376_471338846/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_aaee/lirik_21903603376_471338846/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_aaee/lirik_21903603376_471338846/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_aaee/lirik_21903603376_471338846/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 30.0001933039887,
            mobile: 30.0001933039887,
            high: 30.0001933039887,
            low: 30.0001933039887,
            chunked: 59.9998008383141,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v73062054`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'Frack It Friday - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 21894339920,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 10744,
        created_at: '2016-06-17T16:02:55Z',
        url: 'https://www.twitch.tv/lirik/v/72951584',
        _id: 'v72951584',
        recorded_at: '2016-06-17T16:02:32Z',
        game: 'Shattered Skies',
        length: 27846,
        preview: 'https://static-cdn.jtvnw.net/s3_vods/17eaaae2cb_lirik_21894339920_471039110/thumb/thumb0-320x240.jpg',
        thumbnails: [{
            url: 'https://static-cdn.jtvnw.net/s3_vods/17eaaae2cb_lirik_21894339920_471039110/thumb/thumb0-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/17eaaae2cb_lirik_21894339920_471039110/thumb/thumb1-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/17eaaae2cb_lirik_21894339920_471039110/thumb/thumb2-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/17eaaae2cb_lirik_21894339920_471039110/thumb/thumb3-320x240.jpg',
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 30.0000186739246,
            mobile: 30.0000186739246,
            high: 30.0000186739246,
            low: 30.0000186739246,
            chunked: 59.9999655250631,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v72951584`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'O__________O - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 21862972320,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 15948,
        created_at: '2016-06-15T16:01:19Z',
        url: 'https://www.twitch.tv/lirik/v/72583536',
        _id: 'v72583536',
        recorded_at: '2016-06-15T16:00:56Z',
        game: 'ArmA III',
        length: 26680,
        preview: `${CDN_ENDPOINT}vods_e620/lirik_21862972320_470043041/thumb/thumb0-320x240.jpg`,
        thumbnails: [{
            url: `${CDN_ENDPOINT}vods_e620/lirik_21862972320_470043041/thumb/thumb0-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_e620/lirik_21862972320_470043041/thumb/thumb1-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_e620/lirik_21862972320_470043041/thumb/thumb2-320x240.jpg`,
            type: 'generated',
        }, {
            url: `${CDN_ENDPOINT}vods_e620/lirik_21862972320_470043041/thumb/thumb3-320x240.jpg`,
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 30.0000393546366,
            mobile: 30.0000393546366,
            high: 30.0000393546366,
            low: 30.0000393546366,
            chunked: 60.000003748061,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v72583536`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'This Broadcast Is Currently Offline',
        description: null,
        broadcast_id: 21857433264,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 4853,
        created_at: '2016-06-15T04:51:37Z',
        url: 'https://www.twitch.tv/lirik/v/72521450',
        _id: 'v72521450',
        recorded_at: '2016-06-15T04:51:15Z',
        game: 'Overwatch',
        length: 905,
        preview: 'https://static-cdn.jtvnw.net/s3_vods/39bcacc8ed_lirik_21857433264_469870131/thumb/thumb0-320x240.jpg',
        thumbnails: [{
            url: 'https://static-cdn.jtvnw.net/s3_vods/39bcacc8ed_lirik_21857433264_469870131/thumb/thumb0-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/39bcacc8ed_lirik_21857433264_469870131/thumb/thumb1-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/39bcacc8ed_lirik_21857433264_469870131/thumb/thumb2-320x240.jpg',
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 30.0021655831385,
            mobile: 30.0021655831385,
            high: 30.0021655831385,
            low: 30.0021655831385,
            chunked: 59.9999116088515,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v72521450`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'This Broadcast Is Currently Offline',
        description: null,
        broadcast_id: 21856357968,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 6566,
        created_at: '2016-06-15T03:10:01Z',
        url: 'https://www.twitch.tv/lirik/v/72508054',
        _id: 'v72508054',
        recorded_at: '2016-06-15T03:09:39Z',
        game: 'Overwatch',
        length: 6073,
        preview: 'https://static-cdn.jtvnw.net/s3_vods/aef8fcda45_lirik_21856357968_469836555/thumb/thumb0-320x240.jpg',
        thumbnails: [{
            url: 'https://static-cdn.jtvnw.net/s3_vods/aef8fcda45_lirik_21856357968_469836555/thumb/thumb0-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/aef8fcda45_lirik_21856357968_469836555/thumb/thumb1-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/aef8fcda45_lirik_21856357968_469836555/thumb/thumb2-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/aef8fcda45_lirik_21856357968_469836555/thumb/thumb3-320x240.jpg',
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 30.0001646551298,
            mobile: 30.0001646551298,
            high: 30.0001646551298,
            low: 30.0001646551298,
            chunked: 59.9999999999999,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v72508054`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }, {
        title: 'DAT E3 HYPE DOE - Twitter: @LIRIK - Store: dbh.la/lirik',
        description: null,
        broadcast_id: 21853061200,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 4537,
        created_at: '2016-06-14T22:51:10Z',
        url: 'https://www.twitch.tv/lirik/v/72466470',
        _id: 'v72466470',
        recorded_at: '2016-06-14T22:50:46Z',
        game: 'Dead by Daylight',
        length: 926,
        preview: 'https://static-cdn.jtvnw.net/s3_vods/345d17d7c4_lirik_21853061200_469733599/thumb/thumb0-320x240.jpg',
        thumbnails: [{
            url: 'https://static-cdn.jtvnw.net/s3_vods/345d17d7c4_lirik_21853061200_469733599/thumb/thumb0-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/345d17d7c4_lirik_21853061200_469733599/thumb/thumb1-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/345d17d7c4_lirik_21853061200_469733599/thumb/thumb2-320x240.jpg',
            type: 'generated',
        }, {
            url: 'https://static-cdn.jtvnw.net/s3_vods/345d17d7c4_lirik_21853061200_469733599/thumb/thumb3-320x240.jpg',
            type: 'generated',
        }],
        fps: {
            audio_only: 0.0,
            medium: 30.0020829533472,
            mobile: 30.0020829533472,
            high: 30.0020829533472,
            low: 30.0020829533472,
            chunked: 59.9998489049385,
        },
        resolutions: {
            medium: '852x480',
            mobile: '400x226',
            high: '1280x720',
            low: '640x360',
            chunked: '1280x720',
        },
        _links: {
            self: `${API_HOST}/kraken/videos/v72466470`,
            channel: `${API_HOST}/kraken/channels/lirik`,
        },
        channel: {
            name: 'lirik',
            display_name: 'LIRIK',
        },
    }],
};
/* eslint-enable camelcase */

export const NORMALIZED_V3_RECOMMENDED_VIDEOS = [
    {
        creationDate: '2016-06-27T16:02:56Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_4538/lirik_22054963392_476184335/thumb/thumb0-320x240.jpg',
        title: 'Video Games - Twitter: LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 9770.612553143,
        id: 'v74837329',
        game: 'Town of Salem',
    },
    {
        creationDate: '2016-06-26T16:03:14Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_16e0/lirik_22039247328_475689695/thumb/thumb0-320x240.jpg',
        title: 'Sewb Sewnday - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 26039,
        id: 'v74657627',
        game: 'Dead by Daylight',
    },
    {
        creationDate: '2016-06-25T16:05:40Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_2933/lirik_22022399536_475158426/thumb/thumb0-320x240.jpg',
        title: 'Just Streamin - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 14916,
        id: 'v74462368',
        game: 'Arma 3',
    },
    {
        creationDate: '2016-06-24T16:07:49Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_004a/lirik_22005752288_474628454/thumb/thumb0-320x240.jpg',
        title: 'Frack It Friday - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 28292,
        id: 'v74266505',
        game: 'Battlefield: Bad Company 2',
    },
    {
        creationDate: '2016-06-22T16:05:25Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_f6c1/lirik_21974471824_473621777/thumb/thumb0-320x240.jpg',
        title: 'Playing Video Games - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 27692,
        id: 'v73888453',
        game: 'Duck Game',
    },
    {
        creationDate: '2016-06-21T16:17:54Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_e5fb/lirik_21958569168_473109101/thumb/thumb0-320x240.jpg',
        title: 'GAMIN - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 26365,
        id: 'v73695032',
        game: 'Battlefield: Bad Company 2',
    },
    {
        creationDate: '2016-06-20T16:12:17Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_dc00/lirik_21942634992_472596299/thumb/thumb0-320x240.jpg',
        title: 'Next Stream: Monday @ NOON EST / 5pm GMT ',
        channelName: 'LIRIK',
        duration: 25827,
        id: 'v73509848',
        game: 'Gaming Talk Shows',
    },
    {
        creationDate: '2016-06-19T16:14:08Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_b35e/lirik_21928200128_472131993/thumb/thumb0-320x240.jpg',
        title: 'Sewb Sewnday - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 23686,
        id: 'v73342535',
        game: 'Rust',
    },
    {
        creationDate: '2016-06-18T16:03:32Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_7c66/lirik_21911369648_471589284/thumb/thumb0-320x240.jpg',
        title: 'DA STREMZ - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 26166,
        id: 'v73150249',
        game: 'Gaming Talk Shows',
    },
    {
        creationDate: '2016-06-18T02:53:48Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_aaee/lirik_21903603376_471338846/thumb/thumb0-320x240.jpg',
        // eslint-disable-next-line quotes
        title: "Pretend I'm Not Here",
        channelName: 'LIRIK',
        duration: 10242,
        id: 'v73062054',
        game: 'Worms Reloaded',
    },
    {
        creationDate: '2016-06-17T16:02:55Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/17eaaae2cb_lirik_21894339920_471039110/thumb/thumb0-320x240.jpg',
        title: 'Frack It Friday - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 27846,
        id: 'v72951584',
        game: 'Shattered Skies',
    },
    {
        creationDate: '2016-06-15T16:01:19Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_e620/lirik_21862972320_470043041/thumb/thumb0-320x240.jpg',
        title: 'O__________O - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 26680,
        id: 'v72583536',
        game: 'ArmA III',
    },
    {
        creationDate: '2016-06-15T04:51:37Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/39bcacc8ed_lirik_21857433264_469870131/thumb/thumb0-320x240.jpg',
        title: 'This Broadcast Is Currently Offline',
        channelName: 'LIRIK',
        duration: 905,
        id: 'v72521450',
        game: 'Overwatch',
    },
    {
        creationDate: '2016-06-15T03:10:01Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/aef8fcda45_lirik_21856357968_469836555/thumb/thumb0-320x240.jpg',
        title: 'This Broadcast Is Currently Offline',
        channelName: 'LIRIK',
        duration: 6073,
        id: 'v72508054',
        game: 'Overwatch',
    },
    {
        creationDate: '2016-06-14T22:51:10Z',
        // eslint-disable-next-line max-len
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/345d17d7c4_lirik_21853061200_469733599/thumb/thumb0-320x240.jpg',
        title: 'DAT E3 HYPE DOE - Twitter: @LIRIK - Store: dbh.la/lirik',
        channelName: 'LIRIK',
        duration: 926,
        id: 'v72466470',
        game: 'Dead by Daylight',
    },
];

/* eslint-disable camelcase */
/* eslint-disable max-len */
export const V5_VIDEOS_RESPONSE = {
    _total: 87,
    videos: [{
        title: 'Ŝęǻǥũłŀ',
        description: null,
        description_html: null,
        broadcast_id: 25129106864,
        broadcast_type: 'archive',
        status: 'recorded',
        tag_list: '',
        views: 3249,
        url: 'https://www.twitch.tv/videos/137837442',
        language: 'en',
        created_at: '2017-04-24T19:01:09Z',
        viewable: 'public',
        viewable_at: null,
        published_at: '2017-04-24T19:01:09Z',
        _id: 'v137837442',
        recorded_at: '2017-04-24T19:00:53Z',
        game: 'Overwatch',
        length: 17306,
        preview: {
            small: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb0-80x45.jpg',
            medium: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb0-320x180.jpg',
            large: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb0-640x360.jpg',
            template: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb0-{width}x{height}.jpg',
        },
        animated_preview_url: 'https://vod-storyboards.twitch.tv/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/storyboards/137837442-strip-0.jpg',
        thumbnails: {
            small: [
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb0-80x45.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb1-80x45.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb2-80x45.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb3-80x45.jpg',
                },
            ],
            medium: [
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb0-320x180.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb1-320x180.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb2-320x180.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb3-320x180.jpg',
                },
            ],
            large: [
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb0-640x360.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb1-640x360.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb2-640x360.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb3-640x360.jpg',
                },
            ],
            template: [
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb0-{width}x{height}.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb1-{width}x{height}.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb2-{width}x{height}.jpg',
                },
                {
                    type: 'generated',
                    url: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb3-{width}x{height}.jpg',
                },
            ],
        },
        fps: {
            '160p30': 30,
            '360p30': 30,
            '480p30': 26.25,
            '720p30': 26.25,
            '720p60': 60,
            audio_only: 0,
            chunked: 60,
        },
        resolutions: {
            '160p30': '284x160',
            '360p30': '640x360',
            '480p30': '852x480',
            '720p30': '1280x720',
            '720p60': '1280x720',
            chunked: '1280x720',
        },
        channel: {
            _id: '19070311',
            name: 'a_seagull',
            display_name: 'A_Seagull',
        },
    },
        {
            title: 'time to lose some ranked points',
            description: null,
            description_html: null,
            broadcast_id: 25103390176,
            broadcast_type: 'archive',
            status: 'recorded',
            tag_list: '',
            views: 25088,
            url: 'https://www.twitch.tv/videos/137129575',
            language: 'en',
            created_at: '2017-04-21T19:03:46Z',
            viewable: 'public',
            viewable_at: null,
            published_at: '2017-04-21T19:03:46Z',
            _id: 'v137129575',
            recorded_at: '2017-04-21T19:03:29Z',
            game: 'Overwatch',
            length: 17988,
            preview: {
                small: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb0-80x45.jpg',
                medium: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb0-320x180.jpg',
                large: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb0-640x360.jpg',
                template: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb0-{width}x{height}.jpg',
            },
            animated_preview_url: 'https://vod-storyboards.twitch.tv/8406b1c60c_a_seagull_25103390176_637632381/storyboards/137129575-strip-0.jpg',
            thumbnails: {
                small: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb0-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb1-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb2-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb3-80x45.jpg',
                    },
                ],
                medium: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb0-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb1-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb2-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb3-320x180.jpg',
                    },
                ],
                large: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb0-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb1-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb2-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb3-640x360.jpg',
                    },
                ],
                template: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb0-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb1-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb2-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb3-{width}x{height}.jpg',
                    },
                ],
            },
            fps: {
                '160p30': 30,
                '360p30': 30,
                '480p30': 26.25,
                '720p30': 26.25,
                '720p60': 60,
                audio_only: 0,
                chunked: 60,
            },
            resolutions: {
                '160p30': '284x160',
                '360p30': '640x360',
                '480p30': '852x480',
                '720p30': '1280x720',
                '720p60': '1280x720',
                chunked: '1280x720',
            },
            channel: {
                _id: '19070311',
                name: 'a_seagull',
                display_name: 'A_Seagull',
            },
        },
        {
            title: 'instalock streamer and feed',
            description: null,
            description_html: null,
            broadcast_id: 25088628544,
            broadcast_type: 'archive',
            status: 'recorded',
            tag_list: '',
            views: 25179,
            url: 'https://www.twitch.tv/videos/136700603',
            language: 'en',
            created_at: '2017-04-19T19:00:01Z',
            viewable: 'public',
            viewable_at: null,
            published_at: '2017-04-19T19:00:01Z',
            _id: 'v136700603',
            recorded_at: '2017-04-19T18:59:44Z',
            game: 'Overwatch',
            length: 18440,
            preview: {
                small: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb0-80x45.jpg',
                medium: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb0-320x180.jpg',
                large: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb0-640x360.jpg',
                template: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb0-{width}x{height}.jpg',
            },
            animated_preview_url: 'https://vod-storyboards.twitch.tv/c1ae9eb3f4_a_seagull_25088628544_636709779/storyboards/136700603-strip-0.jpg',
            thumbnails: {
                small: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb0-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb1-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb2-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb3-80x45.jpg',
                    },
                ],
                medium: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb0-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb1-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb2-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb3-320x180.jpg',
                    },
                ],
                large: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb0-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb1-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb2-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb3-640x360.jpg',
                    },
                ],
                template: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb0-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb1-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb2-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb3-{width}x{height}.jpg',
                    },
                ],
            },
            fps: {
                audio_only: 0,
                chunked: 60,
                high: 26.25,
                low: 26.25,
                medium: 26.25,
                mobile: 26.25,
            },
            resolutions: {
                chunked: '1280x720',
                high: '1280x720',
                low: '640x360',
                medium: '852x480',
                mobile: '400x226',
            },
            channel: {
                _id: '19070311',
                name: 'a_seagull',
                display_name: 'A_Seagull',
            },
        },
        {
            title: 'watch a bird perform a series of throws in a stunning display of e-athleticism',
            description: null,
            description_html: null,
            broadcast_id: 25081431760,
            broadcast_type: 'archive',
            status: 'recorded',
            tag_list: '',
            views: 17635,
            url: 'https://www.twitch.tv/videos/136489595',
            language: 'en',
            created_at: '2017-04-18T19:02:51Z',
            viewable: 'public',
            viewable_at: null,
            published_at: '2017-04-18T19:02:51Z',
            _id: 'v136489595',
            recorded_at: '2017-04-18T19:02:34Z',
            game: 'Overwatch',
            length: 5421,
            preview: {
                small: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb0-80x45.jpg',
                medium: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb0-320x180.jpg',
                large: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb0-640x360.jpg',
                template: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb0-{width}x{height}.jpg',
            },
            animated_preview_url: 'https://vod-storyboards.twitch.tv/e744ebeecf_a_seagull_25081431760_636259980/storyboards/136489595-strip-0.jpg',
            thumbnails: {
                small: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb0-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb1-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb2-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb3-80x45.jpg',
                    },
                ],
                medium: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb0-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb1-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb2-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb3-320x180.jpg',
                    },
                ],
                large: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb0-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb1-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb2-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb3-640x360.jpg',
                    },
                ],
                template: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb0-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb1-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb2-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb3-{width}x{height}.jpg',
                    },
                ],
            },
            fps: {
                audio_only: 0,
                chunked: 60,
                high: 26.25,
                low: 26.25,
                medium: 26.25,
                mobile: 26.25,
            },
            resolutions: {
                chunked: '1280x720',
                high: '1280x720',
                low: '640x360',
                medium: '852x480',
                mobile: '400x226',
            },
            channel: {
                _id: '19070311',
                name: 'a_seagull',
                display_name: 'A_Seagull',
            },
        },
        {
            title: 'a_streamer',
            description: null,
            description_html: null,
            broadcast_id: 25073931024,
            broadcast_type: 'archive',
            status: 'recorded',
            tag_list: '',
            views: 35930,
            url: 'https://www.twitch.tv/videos/136283422',
            language: 'en',
            created_at: '2017-04-17T19:01:36Z',
            viewable: 'public',
            viewable_at: null,
            published_at: '2017-04-17T19:01:36Z',
            _id: 'v136283422',
            recorded_at: '2017-04-17T19:01:19Z',
            game: 'Overwatch',
            length: 18200,
            preview: {
                small: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb0-80x45.jpg',
                medium: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb0-320x180.jpg',
                large: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb0-640x360.jpg',
                template: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb0-{width}x{height}.jpg',
            },
            animated_preview_url: 'https://vod-storyboards.twitch.tv/391af5ecdc_a_seagull_25073931024_635791184/storyboards/136283422-strip-0.jpg',
            thumbnails: {
                small: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb0-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb1-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb2-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb3-80x45.jpg',
                    },
                ],
                medium: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb0-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb1-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb2-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb3-320x180.jpg',
                    },
                ],
                large: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb0-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb1-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb2-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb3-640x360.jpg',
                    },
                ],
                template: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb0-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb1-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb2-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb3-{width}x{height}.jpg',
                    },
                ],
            },
            fps: {
                audio_only: 0,
                chunked: 60,
                high: 26.25,
                low: 26.25,
                medium: 26.25,
                mobile: 26.25,
            },
            resolutions: {
                chunked: '1280x720',
                high: '1280x720',
                low: '640x360',
                medium: '852x480',
                mobile: '400x226',
            },
            channel: {
                _id: '19070311',
                name: 'a_seagull',
                display_name: 'A_Seagull',
            },
        },
        {
            title: 'new patch same bird',
            description: null,
            description_html: null,
            broadcast_id: 25023263744,
            broadcast_type: 'archive',
            status: 'recorded',
            tag_list: '',
            views: 32069,
            url: 'https://www.twitch.tv/videos/134940738',
            language: 'en',
            created_at: '2017-04-11T18:03:39Z',
            viewable: 'public',
            viewable_at: null,
            published_at: '2017-04-11T18:03:39Z',
            _id: 'v134940738',
            recorded_at: '2017-04-11T18:03:22Z',
            game: 'Overwatch',
            length: 5362,
            preview: {
                small: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb0-80x45.jpg',
                medium: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb0-320x180.jpg',
                large: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb0-640x360.jpg',
                template: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb0-{width}x{height}.jpg',
            },
            animated_preview_url: 'https://vod-storyboards.twitch.tv/8b6a1abca1_a_seagull_25023263744_632624479/storyboards/134940738-strip-0.jpg',
            thumbnails: {
                small: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb0-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb1-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb2-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb3-80x45.jpg',
                    },
                ],
                medium: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb0-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb1-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb2-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb3-320x180.jpg',
                    },
                ],
                large: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb0-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb1-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb2-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb3-640x360.jpg',
                    },
                ],
                template: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb0-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb1-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb2-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb3-{width}x{height}.jpg',
                    },
                ],
            },
            fps: {
                audio_only: 0,
                chunked: 60,
                high: 26.25,
                low: 26.25,
                medium: 26.25,
                mobile: 26.25,
            },
            resolutions: {
                chunked: '1280x720',
                high: '1280x720',
                low: '640x360',
                medium: '852x480',
                mobile: '400x226',
            },
            channel: {
                _id: '19070311',
                name: 'a_seagull',
                display_name: 'A_Seagull',
            },
        },
        {
            title: 'hello',
            description: null,
            description_html: null,
            broadcast_id: 24904371072,
            broadcast_type: 'archive',
            status: 'recorded',
            tag_list: '',
            views: 55811,
            url: 'https://www.twitch.tv/videos/131714749',
            language: 'en',
            created_at: '2017-03-28T03:31:31Z',
            viewable: 'public',
            viewable_at: null,
            published_at: '2017-03-28T03:31:31Z',
            _id: 'v131714749',
            recorded_at: '2017-03-28T03:31:14Z',
            game: 'Overwatch',
            length: 11559,
            preview: {
                small: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb0-80x45.jpg',
                medium: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb0-320x180.jpg',
                large: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb0-640x360.jpg',
                template: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb0-{width}x{height}.jpg',
            },
            animated_preview_url: 'https://vod-storyboards.twitch.tv/00148067dd_a_seagull_24904371072_625193687/storyboards/131714749-strip-0.jpg',
            thumbnails: {
                small: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb0-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb1-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb2-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb3-80x45.jpg',
                    },
                ],
                medium: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb0-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb1-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb2-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb3-320x180.jpg',
                    },
                ],
                large: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb0-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb1-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb2-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb3-640x360.jpg',
                    },
                ],
                template: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb0-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb1-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb2-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb3-{width}x{height}.jpg',
                    },
                ],
            },
            fps: {
                audio_only: 0,
                chunked: 60,
                high: 26.25,
                low: 26.25,
                medium: 26.25,
                mobile: 26.25,
            },
            resolutions: {
                chunked: '1280x720',
                high: '1280x720',
                low: '640x360',
                medium: '852x480',
                mobile: '400x226',
            },
            channel: {
                _id: '19070311',
                name: 'a_seagull',
                display_name: 'A_Seagull',
            },
        },
        {
            title: 'climbing back from SR decay (hopefully)',
            description: null,
            description_html: null,
            broadcast_id: 24842272688,
            broadcast_type: 'archive',
            status: 'recorded',
            tag_list: '',
            views: 58988,
            url: 'https://www.twitch.tv/videos/130075353',
            language: 'en',
            created_at: '2017-03-20T22:19:45Z',
            viewable: 'public',
            viewable_at: null,
            published_at: '2017-03-20T22:19:45Z',
            _id: 'v130075353',
            recorded_at: '2017-03-20T22:19:28Z',
            game: 'Overwatch',
            length: 16110,
            preview: {
                small: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb0-80x45.jpg',
                medium: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb0-320x180.jpg',
                large: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb0-640x360.jpg',
                template: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb0-{width}x{height}.jpg',
            },
            animated_preview_url: 'https://vod-storyboards.twitch.tv/d9ec84a276_a_seagull_24842272688_621312538/storyboards/130075353-strip-0.jpg',
            thumbnails: {
                small: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb0-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb1-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb2-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb3-80x45.jpg',
                    },
                ],
                medium: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb0-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb1-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb2-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb3-320x180.jpg',
                    },
                ],
                large: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb0-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb1-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb2-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb3-640x360.jpg',
                    },
                ],
                template: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb0-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb1-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb2-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb3-{width}x{height}.jpg',
                    },
                ],
            },
            fps: {
                audio_only: 0,
                chunked: 60,
                high: 26.25,
                low: 26.25,
                medium: 26.25,
                mobile: 26.25,
            },
            resolutions: {
                chunked: '1280x720',
                high: '1280x720',
                low: '640x360',
                medium: '852x480',
                mobile: '400x226',
            },
            channel: {
                _id: '19070311',
                name: 'a_seagull',
                display_name: 'A_Seagull',
            },
        },
        {
            title: 'G R E E T I N G S',
            description: null,
            description_html: null,
            broadcast_id: 24725978656,
            broadcast_type: 'archive',
            status: 'recorded',
            tag_list: '',
            views: 63478,
            url: 'https://www.twitch.tv/videos/127153361',
            language: 'en',
            created_at: '2017-03-08T00:40:16Z',
            viewable: 'public',
            viewable_at: null,
            published_at: '2017-03-08T00:40:16Z',
            _id: 'v127153361',
            recorded_at: '2017-03-08T00:40:00Z',
            game: 'Overwatch',
            length: 13312,
            preview: {
                small: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb0-80x45.jpg',
                medium: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb0-320x180.jpg',
                large: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb0-640x360.jpg',
                template: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb0-{width}x{height}.jpg',
            },
            animated_preview_url: 'https://vod-storyboards.twitch.tv/740b98cba6_a_seagull_24725978656_614044165/storyboards/127153361-strip-0.jpg',
            thumbnails: {
                small: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb0-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb1-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb2-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb3-80x45.jpg',
                    },
                ],
                medium: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb0-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb1-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb2-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb3-320x180.jpg',
                    },
                ],
                large: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb0-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb1-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb2-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb3-640x360.jpg',
                    },
                ],
                template: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb0-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb1-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb2-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb3-{width}x{height}.jpg',
                    },
                ],
            },
            fps: {
                audio_only: 0,
                chunked: 59.99981220410409,
                high: 29.999943661231224,
                low: 30.000169016306316,
                medium: 29.999943661231224,
                mobile: 30.000169016306316,
            },
            resolutions: {
                chunked: '1280x720',
                high: '1280x720',
                low: '640x360',
                medium: '852x480',
                mobile: '400x226',
            },
            channel: {
                _id: '19070311',
                name: 'a_seagull',
                display_name: 'A_Seagull',
            },
        },
        {
            title: 'LIVE FROM THE OMNIC CRISIS',
            description: null,
            description_html: null,
            broadcast_id: 24658374848,
            broadcast_type: 'archive',
            status: 'recorded',
            tag_list: '',
            views: 72731,
            url: 'https://www.twitch.tv/videos/125492423',
            language: 'en',
            created_at: '2017-03-01T00:08:33Z',
            viewable: 'public',
            viewable_at: null,
            published_at: '2017-03-01T00:08:33Z',
            _id: 'v125492423',
            recorded_at: '2017-03-01T00:08:16Z',
            game: 'Overwatch',
            length: 13253,
            preview: {
                small: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb0-80x45.jpg',
                medium: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb0-320x180.jpg',
                large: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb0-640x360.jpg',
                template: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb0-{width}x{height}.jpg',
            },
            animated_preview_url: 'https://vod-storyboards.twitch.tv/e07c19977d_a_seagull_24658374848_609818930/storyboards/125492423-strip-0.jpg',
            thumbnails: {
                small: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb0-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb1-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb2-80x45.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb3-80x45.jpg',
                    },
                ],
                medium: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb0-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb1-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb2-320x180.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb3-320x180.jpg',
                    },
                ],
                large: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb0-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb1-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb2-640x360.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb3-640x360.jpg',
                    },
                ],
                template: [
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb0-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb1-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb2-{width}x{height}.jpg',
                    },
                    {
                        type: 'generated',
                        url: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb3-{width}x{height}.jpg',
                    },
                ],
            },
            fps: {
                audio_only: 0,
                chunked: 59.99024876366637,
                high: 29.99538845895457,
                low: 29.995690261379007,
                medium: 29.99538845895457,
                mobile: 29.995690261379007,
            },
            resolutions: {
                chunked: '1280x720',
                high: '1280x720',
                low: '640x360',
                medium: '852x480',
                mobile: '400x226',
            },
            channel: {
                _id: '19070311',
                name: 'a_seagull',
                display_name: 'A_Seagull',
            },
        }],
};
/* eslint-enable camelcase */

export const NORMALIZED_V5_RECOMMENDED_VIDEOS = [
    {
        creationDate: '2017-04-24T19:01:09Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/v1/AUTH_system/vods_9fa9/a_seagull_25129106864_639239674/thumb/thumb0-320x180.jpg',
        title: 'Ŝęǻǥũłŀ',
        channelName: 'A_Seagull',
        duration: 17306,
        id: 'v137837442',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
    {
        creationDate: '2017-04-21T19:03:46Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/8406b1c60c_a_seagull_25103390176_637632381/thumb/thumb0-320x180.jpg',
        title: 'time to lose some ranked points',
        channelName: 'A_Seagull',
        duration: 17988,
        id: 'v137129575',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
    {
        creationDate: '2017-04-19T19:00:01Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/c1ae9eb3f4_a_seagull_25088628544_636709779/thumb/thumb0-320x180.jpg',
        title: 'instalock streamer and feed',
        channelName: 'A_Seagull',
        duration: 18440,
        id: 'v136700603',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
    {
        creationDate: '2017-04-18T19:02:51Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/e744ebeecf_a_seagull_25081431760_636259980/thumb/thumb0-320x180.jpg',
        title: 'watch a bird perform a series of throws in a stunning display of e-athleticism',
        channelName: 'A_Seagull',
        duration: 5421,
        id: 'v136489595',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
    {
        creationDate: '2017-04-17T19:01:36Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/391af5ecdc_a_seagull_25073931024_635791184/thumb/thumb0-320x180.jpg',
        title: 'a_streamer',
        channelName: 'A_Seagull',
        duration: 18200,
        id: 'v136283422',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
    {
        creationDate: '2017-04-11T18:03:39Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/8b6a1abca1_a_seagull_25023263744_632624479/thumb/thumb0-320x180.jpg',
        title: 'new patch same bird',
        channelName: 'A_Seagull',
        duration: 5362,
        id: 'v134940738',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
    {
        creationDate: '2017-03-28T03:31:31Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/00148067dd_a_seagull_24904371072_625193687/thumb/thumb0-320x180.jpg',
        title: 'hello',
        channelName: 'A_Seagull',
        duration: 11559,
        id: 'v131714749',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
    {
        creationDate: '2017-03-20T22:19:45Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/d9ec84a276_a_seagull_24842272688_621312538/thumb/thumb0-320x180.jpg',
        title: 'climbing back from SR decay (hopefully)',
        channelName: 'A_Seagull',
        duration: 16110,
        id: 'v130075353',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
    {
        creationDate: '2017-03-08T00:40:16Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/740b98cba6_a_seagull_24725978656_614044165/thumb/thumb0-320x180.jpg',
        title: 'G R E E T I N G S',
        channelName: 'A_Seagull',
        duration: 13312,
        id: 'v127153361',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
    {
        creationDate: '2017-03-01T00:08:33Z',
        thumbnailURL: 'https://static-cdn.jtvnw.net/s3_vods/e07c19977d_a_seagull_24658374848_609818930/thumb/thumb0-320x180.jpg',
        title: 'LIVE FROM THE OMNIC CRISIS',
        channelName: 'A_Seagull',
        duration: 13253,
        id: 'v125492423',
        game: 'Overwatch',
        recommendationType: 'type1',
    },
];
/* eslint-enable max-len, indent */
