import flatten from 'lodash/flatten';

export const TEST_MUTED_SEGMENTS_RESPONSE = Object.freeze([
    {
        offset: 10,
        duration: 10,
    },
    {
        offset: 10,
        duration: 10,
    },
    {
        offset: 10,
        duration: 20,
    },
    {
        offset: 30,
        duration: 10,
    },
    {
        offset: 50,
        duration: 10,
    },
    {
        offset: 15,
        duration: 0,
    },
    {
        offset: 52,
        duration: 5,
    },
]);

export const TEST_NORMALIZED_MUTED_SEGMENTS = Object.freeze([
    {
        offset: 10,
        duration: 30,
    },
    {
        offset: 50,
        duration: 10,
    },
]);

export const TEST_PREVIEWS = Object.freeze({
    count: 191,
    lq: {
        width: 110,
        height: 62,
        rows: 40,
        cols: 5,
        URLs: ['http://test.com/directory/directory/26108407-low-0.jpg'],
    },
    hq: {
        width: 220,
        height: 124,
        rows: 10,
        cols: 5,
        URLs: [
            'http://test.com/directory/directory/26108407-high-0.jpg',
            'http://test.com/directory/directory/26108407-high-1.jpg',
            'http://test.com/directory/directory/26108407-high-2.jpg',
            'http://test.com/directory/directory/26108407-high-3.jpg',
        ],
    },
});

export const TEST_PREVIEW_POPUP_OBJECT = Object.freeze({
    info: '',
    thumbOver: {
        height: 83.41818181818182,
        sheetWidth: 740,
        url: 'http://test.com/directory/directory/26108407-high-1.jpg',
        width: 148,
        x: 296,
        y: 83.41818181818182,
    },
    thumbUnder: {
        height: 83.41818181818182,
        sheetWidth: 740,
        url: 'http://test.com/directory/directory/26108407-low-0.jpg',
        width: 148,
        x: 296,
        y: 917.6,
    },
    timestamp: '00:00:30',
    title: '',
    width: 148,
});

/* eslint-disable camelcase */
export const TEST_HEARTHSTONE_VCA_TAGS = Object.freeze([
    {
        description: '',
        end_sec: 10,
        game_type: 'hs',
        id: 'NzJiZjhkZmY',
        start_sec: 0,
        title: 'Druid vs Druid',
        thumbnail_index: null,
        game_data: {
            outcome: 1,
            type: 0,
            characters: ['Druid', 'Druid'],
        },
    },
    {
        description: '',
        end_sec: 20,
        game_type: 'hs',
        id: 'asdFefAaDa',
        start_sec: 10,
        title: 'Mage vs Warrior',
        thumbnail_index: [1,1],
        game_data: {
            outcome: 1,
            type: 0,
            characters: ['Mage', 'Warrior'],
        },
    },
]);

export const TEST_NORMALIZED_HEARTHSTONE_VCA_MARKERS = Object.freeze([
    {
        id: 'NzJiZjhkZmY',
        info: '<strong>Druid</strong> vs Druid',
        startTime: 0,
        title: 'Match 1',
        thumbnail: {
            cols: 0,
            height: 0,
            imageURL: '',
            width: 0,
            x: 0,
            y: 0,
        },
        type: 'game metadata',
    },
    {
        id: 'asdFefAaDa',
        info: '<strong>Mage</strong> vs Warrior',
        startTime: 10,
        title: 'Match 2',
        thumbnail: {
            cols: 10,
            height: 124,
            imageURL: 'https://clipmn.twitch.tv/prod/thumbs/83/55/tw-v55888355_sprite.jpg',
            width: 220,
            x: 220,
            y: 124,
        },
        type: 'game metadata',
    },
]);

// eslint-disable-next-line camelcase
export const TEST_CSGO_VCA_TAGS = Object.freeze([
    {
        description: '',
        end_sec: 1374.01,
        game_type: 'csgo',
        id: 'NzJiZjhkZmY',
        start_sec: 30,
        title: '',
        thumbnail_index: [1,0],
        game_data: {
            type: 0,
        },
    },
    {
        description: '',
        end_sec: 1374.01,
        game_type: 'csgo',
        id: 'NzJiZjhkZmY',
        start_sec: 40,
        title: '',
        thumbnail_index: [1,1],
        game_data: {
            type: 0,
        },
    },
]);

export const TEST_NORMALIZED_CSGO_VCA_MARKERS = Object.freeze([
    {
        id: 'NzJiZjhkZmY',
        info: '',
        startTime: 30,
        title: 'Match 1',
        thumbnail: {
            cols: 10,
            height: 124,
            imageURL: 'https://clipmn.twitch.tv/prod/thumbs/83/55/tw-v55888355_sprite.jpg',
            width: 220,
            x: 0,
            y: 124,
        },
        type: 'game metadata',
    },
    {
        id: 'NzJiZjhkZmY',
        info: '',
        startTime: 40,
        title: 'Match 2',
        thumbnail: {
            cols: 10,
            height: 124,
            imageURL: 'https://clipmn.twitch.tv/prod/thumbs/83/55/tw-v55888355_sprite.jpg',
            width: 220,
            x: 220,
            y: 124,
        },
        type: 'game metadata',
    },
]);

// eslint-disable-next-line camelcase
export const TEST_LEAGUE_VCA_TAGS = Object.freeze([
    {
        description: '',
        end_sec: 1374.01,
        game_type: 'lol',
        id: 'NzJiZjhkZmY',
        start_sec: 50,
        title: '',
        thumbnail_index: [1,0],
        game_data: {
            type: 0,
        },
    },
    {
        description: '',
        end_sec: 1374.01,
        game_type: 'lol',
        id: 'NzJiZjhkZmY',
        start_sec: 60,
        title: '',
        thumbnail_index: [1,1],
        game_data: {
            type: 0,
        },
    },
]);

export const TEST_NORMALIZED_LEAGUE_VCA_MARKERS = Object.freeze([
    {
        id: 'NzJiZjhkZmY',
        info: '',
        startTime: 50,
        title: 'Match 1',
        thumbnail: {
            cols: 10,
            height: 124,
            imageURL: 'https://clipmn.twitch.tv/prod/thumbs/83/55/tw-v55888355_sprite.jpg',
            width: 220,
            x: 0,
            y: 124,
        },
        type: 'game metadata',
    },
    {
        id: 'NzJiZjhkZmY',
        info: '',
        startTime: 60,
        title: 'Match 2',
        thumbnail: {
            cols: 10,
            height: 124,
            imageURL: 'https://clipmn.twitch.tv/prod/thumbs/83/55/tw-v55888355_sprite.jpg',
            width: 220,
            x: 220,
            y: 124,
        },
        type: 'game metadata',
    },
]);

// eslint-disable-next-line camelcase
export const TEST_ROCKET_LEAGUE_VCA_TAGS = Object.freeze([
    {
        description: '',
        end_sec: 70,
        game_type: 'rl',
        id: 'NzJiZjhkZmY',
        start_sec: 70,
        title: '',
        thumbnail_index: [1,0],
        game_data: {
            type: 0,
        },
    },
    {
        description: '',
        end_sec: 80,
        game_type: 'rl',
        id: 'NzJiZjhkZmY',
        start_sec: 80,
        title: '',
        thumbnail_index: [1,1],
        game_data: {
            type: 0,
        },
    },
]);

export const TEST_NORMALIZED_ROCKET_LEAGUE_VCA_MARKERS = Object.freeze([
    {
        id: 'NzJiZjhkZmY',
        info: '',
        startTime: 70,
        title: 'Match 1',
        thumbnail: {
            cols: 10,
            height: 124,
            imageURL: 'https://clipmn.twitch.tv/prod/thumbs/83/55/tw-v55888355_sprite.jpg',
            width: 220,
            x: 0,
            y: 124,
        },
        type: 'game metadata',
    },
    {
        id: 'NzJiZjhkZmY',
        info: '',
        startTime: 80,
        title: 'Match 2',
        thumbnail: {
            cols: 10,
            height: 124,
            imageURL: 'https://clipmn.twitch.tv/prod/thumbs/83/55/tw-v55888355_sprite.jpg',
            width: 220,
            x: 220,
            y: 124,
        },
        type: 'game metadata',
    },
]);

export const TEST_VCA_MARKER_RESPONSE = Object.freeze({
    version: 1,
    data: {
        channel: 'nl_Kripp',
        id: 'v55888355',
        thumbnail_sheet: 'thumbs/83/55/tw-v55888355_sprite.jpg',
        version: 1,
        thumbnail_size: [220,124],
        sheet_dimensions: [20,10],
        tags: flatten([
            TEST_HEARTHSTONE_VCA_TAGS,
            TEST_CSGO_VCA_TAGS,
            TEST_LEAGUE_VCA_TAGS,
            TEST_ROCKET_LEAGUE_VCA_TAGS,
        ]),
    },
});
/* eslint-enable camelcase */

export const TEST_NORMALIZED_VCA_MARKERS = Object.freeze(flatten([
    TEST_NORMALIZED_HEARTHSTONE_VCA_MARKERS,
    TEST_NORMALIZED_CSGO_VCA_MARKERS,
    TEST_NORMALIZED_LEAGUE_VCA_MARKERS,
    TEST_NORMALIZED_ROCKET_LEAGUE_VCA_MARKERS,
]).sort((m1, m2) => m1.startTime - m2.startTime));

/* eslint-disable camelcase */
export const TEST_VOD_MARKER_RESPONSE = Object.freeze({
    markers: {
        game_changes: [
            {
                label: 'Overwatch',
                thumbnail: {
                    column: 0,
                    height: 190,
                    row: 0,
                    sheet_cols: 1,
                    sheet_rows: 1,
                    sheet_url: 'https://static-cdn.jtvnw.net/ttv-boxart/Overwatch-138x190.jpg',
                    width: 138,
                },
                time: 7605,
            },
            {
                label: 'Overwatch',
                thumbnail: {
                    column: 0,
                    height: 190,
                    row: 0,
                    sheet_cols: 1,
                    sheet_rows: 1,
                    sheet_url: 'https://static-cdn.jtvnw.net/ttv-boxart/Left-FOR-DEAD-138x190.jpg',
                    width: 138,
                },
                time: 100,
            },
        ],
    },
    vod_id: '115665087',
});

export const TEST_NORMALIZED_VOD_MARKERS = Object.freeze([
    {
        info: '',
        startTime: 100,
        thumbnail: {
            cols: 1,
            height: 190,
            imageURL: 'https://static-cdn.jtvnw.net/ttv-boxart/Left-FOR-DEAD-138x190.jpg',
            width: 138,
            x: 0,
            y: 0,
        },
        title: '',
        type: 'game change',
    },
    {
        info: '',
        startTime: 7605,
        thumbnail: {
            cols: 1,
            height: 190,
            imageURL: 'https://static-cdn.jtvnw.net/ttv-boxart/Overwatch-138x190.jpg',
            width: 138,
            x: 0,
            y: 0,
        },
        title: '',
        type: 'game change',
    },
]);
/* eslint-enable camelcase */
