import sinon from 'sinon';
import { init as initStore } from 'state';
import { unitTest } from 'tests/utils/module';
import * as UniqueId from 'util/unique-id';
import * as AnalyticsActions from 'actions/analytics';

unitTest('actions | analytics', function() {
    QUnit.module('resetPlaySession', function(hooks) {
        hooks.beforeEach(function() {
            this.store = initStore();
            sinon.stub(UniqueId, 'generate').returns(`someFantasticPlaySession_${QUnit.config.current.testId}`);
            sinon.stub(Date, 'now').returns(1466200570430);
        });

        hooks.afterEach(function() {
            UniqueId.generate.restore();
            Date.now.restore();
        });

        QUnit.test('should set play_session_id to a value from unique id generator', function(assert) {
            assert.notEqual(
                this.store.getState().analytics.playSessionId,
                `someFantasticPlaySession_${QUnit.config.current.testId}`
            );
            this.store.dispatch(AnalyticsActions.resetPlaySession());
            assert.equal(
                this.store.getState().analytics.playSessionId,
                `someFantasticPlaySession_${QUnit.config.current.testId}`
            );
        });

        QUnit.test('should set playSessionStartTime to current Unix time (in ms)', function(assert) {
            assert.notEqual(this.store.getState().analytics.playSessionStartTime, 1466200570430);
            this.store.dispatch(AnalyticsActions.resetPlaySession());
            assert.equal(this.store.getState().analytics.playSessionStartTime, 1466200570430);
        });
    });
});
