import { init as initStore } from 'state';
import { unitTest } from 'tests/utils/module';
import * as ChromecastActions from 'actions/chromecast';

unitTest('actions | chromecast', function() {
    QUnit.module('resetPlaySession', function(hooks) {
        hooks.beforeEach(function() {
            this.store = initStore();
        });

        QUnit.test('should change deviceName to string provided', function(assert) {
            const deviceName = `my-ca$t-device-${QUnit.config.current.testId}`;
            assert.notEqual(this.store.getState().chromecast.playSessionId, deviceName);

            this.store.dispatch(ChromecastActions.setDeviceName(deviceName));
            assert.equal(this.store.getState().chromecast.deviceName, deviceName);
        });
    });

    QUnit.test('setCastingState is formatted correctly', function(assert) {
        const castingState = QUnit.config.current.testId;
        const action = ChromecastActions.setCastingState(castingState);

        const expectedAction = {
            type: ChromecastActions.ACTION_SET_CASTING_STATE,
            castingState,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('startCast is formatted correctly', function(assert) {
        const action = ChromecastActions.startCast();

        const expectedAction = {
            type: ChromecastActions.ACTION_START_CASTING,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('stopCast is formatted correctly', function(assert) {
        const action = ChromecastActions.stopCast();

        const expectedAction = {
            type: ChromecastActions.ACTION_STOP_CASTING,
        };

        assert.deepEqual(action, expectedAction);
    });
});
