import { ACTION_INVALID_COMMUNITIES_DATA, ACTION_SET_COMMUNITIES_DATA, setCommunitiesData } from 'actions/communities';
import { unitTest } from 'tests/utils/module';

unitTest('actions | communities', function() {
    QUnit.module('setCommunitiesData', function() {
        QUnit.test('returns a Set Communities Data action', function(assert) {
            const data = Object.freeze({
                communities: [{
                    my: 'data',
                    _id: '123-4567-890',
                }, {
                    my: 'data2',
                    _id: '098-7654-321',
                }],
            });
            const expected = {
                data: data.communities,
                ids: '123-4567-890,098-7654-321',
            };
            const action = setCommunitiesData(data);
            assert.equal(action.type, ACTION_SET_COMMUNITIES_DATA);
            assert.deepEqual(action.communities, expected);
        });

        QUnit.test('returns an empty communities data action if there are no communities', function(assert) {
            const action = setCommunitiesData({ communities: [] });
            const expected = {
                data: [],
                ids: '',
            };
            assert.equal(action.type, ACTION_SET_COMMUNITIES_DATA);
            assert.deepEqual(action.communities, expected);
        });

        QUnit.test('returns an invalid communities data action if no data is passed in', function(assert) {
            const action = setCommunitiesData();
            assert.equal(action.type, ACTION_INVALID_COMMUNITIES_DATA);
        });
    });
});
