import sinon from 'sinon';
import * as ComscoreActions from 'actions/comscore';

QUnit.module('Actions | Comscore', function() {
    QUnit.module('sendPlayerBeacon', function(hooks) {
        hooks.beforeEach(function() {
            this.window = {};

            this.getState = () => {
                return {
                    window: this.window,
                };
            };
        });

        QUnit.module('when the Comscore beacon has already loaded', function(hooks) {
            hooks.beforeEach(function() {
                this.window.COMSCORE = {
                    beacon: sinon.spy(),
                };
            });

            QUnit.test('sends a tracking beacon to Comscore via the beacon method', function(assert) {
                const action = ComscoreActions.sendPlayerBeacon();
                const dispatch = sinon.spy();

                action(dispatch, this.getState);

                assert.equal(dispatch.callCount, 0);
                assert.equal(this.window.COMSCORE.beacon.callCount, 1);
                assert.ok(this.window.COMSCORE.beacon.calledWithMatch({
                    c1: '7',
                    c2: '6745306',
                    c3: '2246787049647177590',
                    c4: '',
                    c5: '',
                    c6: '',
                }));
            });
        });

        QUnit.module('when the Comscore beacon has not yet loaded', function() {
            QUnit.test('creates & populates a tracking beacon queue if needed', function(assert) {
                const action = ComscoreActions.sendPlayerBeacon();
                const dispatch = sinon.spy();

                action(dispatch, this.getState);

                assert.equal(dispatch.callCount, 0);
                assert.deepEqual(this.window._comscore, [{
                    c1: '7',
                    c2: '6745306',
                    c3: '2246787049647177590',
                    c4: '',
                    c5: '',
                    c6: '',
                }]);
            });

            QUnit.test('queues a tracking beacon if a queue exists', function(assert) {
                this.window._comscore = [];
                const action = ComscoreActions.sendPlayerBeacon();
                const dispatch = sinon.spy();

                action(dispatch, this.getState);

                assert.equal(dispatch.callCount, 0);
                assert.deepEqual(this.window._comscore, [{
                    c1: '7',
                    c2: '6745306',
                    c3: '2246787049647177590',
                    c4: '',
                    c5: '',
                    c6: '',
                }]);
            });
        });
    });

    QUnit.module('sendVideoBeacon', function(hooks) {
        hooks.beforeEach(function() {
            this.window = {};

            this.getState = () => {
                return {
                    window: this.window,
                };
            };
        });

        QUnit.module('when the Comscore beacon has already loaded', function(hooks) {
            hooks.beforeEach(function() {
                this.window.COMSCORE = {
                    beacon: sinon.spy(),
                };
            });

            QUnit.test('sends a tracking beacon to Comscore via the beacon method', function(assert) {
                const action = ComscoreActions.sendVideoBeacon();
                const dispatch = sinon.spy();

                action(dispatch, this.getState);

                assert.equal(dispatch.callCount, 0);
                assert.equal(this.window.COMSCORE.beacon.callCount, 1);
                assert.ok(this.window.COMSCORE.beacon.calledWithMatch({
                    c1: '1',
                    c2: '6745306',
                    c3: 'TWITCH',
                    c4: 'twitch.tv',
                    c5: '03',
                    c6: '',
                }));
            });
        });

        QUnit.module('when the Comscore beacon has not yet loaded', function() {
            QUnit.test('creates & populates a tracking beacon queue if needed', function(assert) {
                const action = ComscoreActions.sendVideoBeacon();
                const dispatch = sinon.spy();

                action(dispatch, this.getState);

                assert.equal(dispatch.callCount, 0);
                assert.deepEqual(this.window._comscore, [{
                    c1: '1',
                    c2: '6745306',
                    c3: 'TWITCH',
                    c4: 'twitch.tv',
                    c5: '03',
                    c6: '',
                }]);
            });

            QUnit.test('queues a tracking beacon if a queue exists', function(assert) {
                this.window._comscore = [];
                const action = ComscoreActions.sendVideoBeacon();
                const dispatch = sinon.spy();

                action(dispatch, this.getState);

                assert.equal(dispatch.callCount, 0);
                assert.deepEqual(this.window._comscore, [{
                    c1: '1',
                    c2: '6745306',
                    c3: 'TWITCH',
                    c4: 'twitch.tv',
                    c5: '03',
                    c6: '',
                }]);
            });
        });
    });
});
