import * as EmbedEventEmitterActions from 'actions/embed-event-emitter';

class FakeEmbedEventEmitter {}

QUnit.module('actions | embed-event-emitter', function() {
    QUnit.test('embedHostLoaded is formatted correctly', function(assert) {
        const embedHost = new FakeEmbedEventEmitter();
        const action = EmbedEventEmitterActions.embedHostLoaded(embedHost);

        const expectedAction = {
            type: EmbedEventEmitterActions.ACTION_USE_EMBED_EVENT_EMITTER,
            embedHost,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('adCompanionRendered is formatted correctly', function(assert) {
        const event = 'adcompanionrendered';
        const data = 'ima';
        const action = EmbedEventEmitterActions.adCompanionRendered(event, data);

        const expectedAction = {
            type: EmbedEventEmitterActions.ACTION_AD_COMPANION_EVENT,
            event,
            data,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('emitFirstPartyAnalyticEvent is formatted correctly', function(assert) {
        const event = {
            name: 'an event name',
            properties: {
                aproperty: 'aproperty',
            },
        };
        const action = EmbedEventEmitterActions.emitFirstPartyAnalyticEvent(event);

        const expectedAction = {
            type: EmbedEventEmitterActions.ACTION_FIRST_PARTY_ANALYTIC_EVENT,
            event: event.name,
            data: event.properties,
        };

        assert.deepEqual(action, expectedAction);
    });
});
