import { unitTest } from 'tests/utils/module';
import * as EnvActions from 'actions/env';
import * as PlayerType from 'util/player-type';

unitTest('actions | env', function() {
    QUnit.module('setEnvironment', function() {
        QUnit.test('creates a correctly formatted Set Environment action', function(assert) {
            const deviceId = `device_${QUnit.config.current.testId}`;
            const action = EnvActions.setEnvironment({
                deviceId,
            });

            assert.deepEqual(action, {
                type: EnvActions.ACTION_SET_ENVIRONMENT,
                deviceId,
            });
        });
    });

    QUnit.module('setPlayerType', function() {
        QUnit.test('creates a correctly formatted Set Player Type action', function(assert) {
            const action = EnvActions.setPlayerType(PlayerType.PLAYER_SITE);

            assert.deepEqual(action, {
                type: EnvActions.ACTION_SET_PLAYER_TYPE,
                playerType: PlayerType.PLAYER_SITE,
            });
        });
    });

    QUnit.module('setTwitchEverywhereParams', function() {
        QUnit.test('creates a correctly formatted Set Twitch Everywhere Params action', function(assert) {
            const action = EnvActions.setTwitchEverywhereParams({ foo: 'bar' });

            assert.deepEqual(action, {
                type: EnvActions.ACTION_SET_TWITCH_EVERYWHERE_PARAMS,
                params: { foo: 'bar' },
            });
        });
    });
});
