import { setError, ACTION_ERROR } from 'actions/error';
import Errors from 'errors';

QUnit.module('actions | Error Handling', function() {
    QUnit.module('setError', function() {
        QUnit.test('returns a set error action with error code if error code is valid', function(assert) {
            const errorCode = Errors.CODES.ABORTED;
            const action = setError(errorCode);

            assert.equal(action.type, ACTION_ERROR);
            assert.equal(action.code, errorCode);
        });

        QUnit.test('errors out if error code is invalid', function(assert) {
            assert.expect(2);
            const errorCode = 'abc';
            try {
                setError(errorCode);
            } catch (e) {
                assert.ok(e instanceof Error, 'throws error object');
                assert.equal(e.message,
                    `Invalid error code ${errorCode}`,
                    'error message is correct'
                );
            }
        });
    });
});
