import * as EventEmitterActions from 'actions/event-emitter';

class FakeEmitter {}

QUnit.module('actions | event-emitter', function() {
    QUnit.test('eventEmitterLoaded is formatted correctly', function(assert) {
        const emitter = new FakeEmitter();
        const action = EventEmitterActions.eventEmitterLoaded(emitter);

        const expectedAction = {
            type: EventEmitterActions.ACTION_USE_EVENT_EMITTER,
            emitter,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('emitFullscreenChange is formatted correctly', function(assert) {
        const action = EventEmitterActions.emitFullscreenChange();

        const expectedAction = {
            type: EventEmitterActions.ACTION_EMIT_FULLSCREEN_CHANGE,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('emitOpenStream is formatted correctly', function(assert) {
        const action = EventEmitterActions.emitOpenStream();

        const expectedAction = {
            type: EventEmitterActions.ACTION_EMIT_OPEN_STREAM,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('emitTransitionToCollection is formatted correctly', function(assert) {
        const collectionId = '12345';
        const vodId = 'v1231';
        const action = EventEmitterActions.emitTransitionToCollection(collectionId, vodId);
        const expectedAction = {
            type: EventEmitterActions.ACTION_TRANSITION_TO_COLLECTION,
            vodId,
            collectionId,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('emitTransitionToRecommendedVOD is formatted correctly', function(assert) {
        const vodId = 'v1231';
        const action = EventEmitterActions.emitTransitionToRecommendedVOD(vodId);
        const expectedAction = {
            type: EventEmitterActions.ACTION_TRANSITION_TO_REC_VOD,
            vodId,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('emitAdPlayEvent is formatted correctly', function(assert) {
        const action = EventEmitterActions.emitAdPlayEvent();
        const expectedAction = {
            type: EventEmitterActions.ACTION_AD_PLAY,
        };
        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('emitAdPlayingEvent is formatted correctly', function(assert) {
        const action = EventEmitterActions.emitAdPlayingEvent();
        const expectedAction = {
            type: EventEmitterActions.ACTION_AD_PLAYING,
        };
        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('emitAdPauseEvent is formatted correctly', function(assert) {
        const action = EventEmitterActions.emitAdPauseEvent();
        const expectedAction = {
            type: EventEmitterActions.ACTION_AD_PAUSE,
        };
        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('emitPlayerReady is formatted correctly', function(assert) {
        const action = EventEmitterActions.emitPlayerReady();
        const expectedAction = {
            type: EventEmitterActions.ACTION_EMIT_PLAYER_READY,
        };
        assert.deepEqual(action, expectedAction);
    });
});
