import Client from 'minixperiment-client';
import * as ExperimentsActions from 'actions/experiments';

QUnit.module('actions | experiments', function() {
    QUnit.module('setExperiments', function() {
        QUnit.test('returns a Set Experiments action', function(assert) {
            const client = {};
            const action = ExperimentsActions.setExperiments(client);

            assert.equal(action.type, ExperimentsActions.ACTION_SET_EXPERIMENTS);
            assert.equal(action.experiments, client);
        });
    });

    QUnit.module('loadExperiments', function() {
        QUnit.test('returns a Set Experiments action with a new client', function(assert) {
            const userConfig = {
                login: 'kappaspammer1',
                deviceID: 'abcdef123456',
            };
            const action = ExperimentsActions.loadExperiments(userConfig);

            assert.equal(action.type, ExperimentsActions.ACTION_SET_EXPERIMENTS);
            // There must be a better way to determine if the created experiment
            // client actually uses the given values
            assert.ok(action.experiments instanceof Client);
            assert.equal(action.experiments._username, userConfig.login);
            assert.equal(action.experiments._deviceID, userConfig.deviceID);
        });
    });
});
