import { ACTION_SET_MANIFEST_INFO, setManifestInfo } from 'actions/manifest-info';
import { DEFAULT_MANIFEST_INFO } from 'state/manifest-info';

QUnit.module('actions | manifest-info', function() {
    QUnit.module('setManifestInfo', function() {
        QUnit.test('returns a set manifest info action', function(assert) {
            const action = setManifestInfo(DEFAULT_MANIFEST_INFO);
            assert.equal(action.type, ACTION_SET_MANIFEST_INFO);
            assert.deepEqual(action.info, DEFAULT_MANIFEST_INFO);
        });
        QUnit.test('normalizes the manifest info object', function(assert) {
            const unnormalizedManifestInfo = {
                abs: 'false',
                suppress: 'true',
                // eslint-disable-next-line camelcase
                broadcast_id: '12345',
                future: 'true',
            };

            const normalizedManifestInfo = {
                abs: false,
                suppress: true,
                // eslint-disable-next-line camelcase
                broadcast_id: 12345,
                future: true,
            };

            const action = setManifestInfo(unnormalizedManifestInfo);
            assert.equal(action.type, ACTION_SET_MANIFEST_INFO);
            assert.deepEqual(action.info, normalizedManifestInfo);
        });
    });
});
