import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import * as NotificationsActions from 'actions/notifications';

function FirstPopUp() {
    return (
        <h1> first </h1>
    );
}

const testNotifications = Object.freeze([
    FirstPopUp,
]);

reactTest('actions | notifications', function() {
    QUnit.test('addNotification is formatted correctly', function(assert) {
        const action = NotificationsActions.addNotification(testNotifications);

        const expectedAction = {
            type: NotificationsActions.ACTION_ADD_NOTIFICATION,
            notification: testNotifications,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('removeNotification is formatted correctly', function(assert) {
        const action = NotificationsActions.removeNotification();

        const expectedAction = {
            type: NotificationsActions.ACTION_REMOVE_NOTIFICATION,
        };

        assert.deepEqual(action, expectedAction);
    });
});
