import { setPlayerOptions, ACTION_SET_PROVIDED_OPTIONS } from 'actions/player-options';

QUnit.module('actions | player-options', function(hooks) {
    hooks.beforeEach(function() {
        this.testId = QUnit.config.current.testId;
    });

    QUnit.test('setPlayerOptions returns action to set a specified subset of provided options', function(assert) {
        const playerOptions = {
            showInfo: true,
            branding: true,
            debug: false,
            showtheatre: false,
            someExtraOption: 'nope',
            channel: `channel_${this.testId}`,
            channelId: `channelId_${this.testId}`,
            video: `video_${this.testId}`,
            collection: `collection_${this.testId}`,
            /* eslint-disable camelcase */
            tt_content: 'content',
            tt_medium: 'medium',
            force_preroll: false,
            force_midroll: false,
            force_preroll_id: 0,
            force_midroll_id: 0,
            /* eslint-enable camelcase */
        };
        const action = setPlayerOptions(playerOptions);

        const expectedAction = {
            type: ACTION_SET_PROVIDED_OPTIONS,
            playerOptions: {
                showInfo: true,
                branding: true,
                showtheatre: false,
                channel: `channel_${this.testId}`,
                channelId: `channelId_${this.testId}`,
                video: `video_${this.testId}`,
                collection: `collection_${this.testId}`,
                /* eslint-disable camelcase */
                tt_content: 'content',
                tt_medium: 'medium',
                force_preroll: false,
                force_midroll: false,
                force_preroll_id: 0,
                force_midroll_id: 0,
                /* eslint-enable camelcase */
            },
        };
        assert.deepEqual(action, expectedAction, 'includes subset of options and excludes extraneous ones');
    });
});
