import { ACTION_SET_FULLSCREEN, ACTION_SET_CAN_FULLSCREEN, setFullScreen,
         setCanFullScreen, toggleFullScreen, ACTION_TOGGLE_FULLSCREEN,
         toggleTheatreMode, ACTION_TOGGLE_THEATRE_MODE, ACTION_SET_THEATRE_MODE,
         setTheatreMode } from 'actions/screen-mode';

QUnit.module('actions | screen-mode', function() {
    QUnit.test('setFullScreen is formatted correctly', function(assert) {
        const action = setFullScreen(true);

        const expectedAction = {
            type: ACTION_SET_FULLSCREEN,
            isFullScreen: true,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('setCanFullScreen is formatted correctly', function(assert) {
        const action = setCanFullScreen(true);

        const expectedAction = {
            type: ACTION_SET_CAN_FULLSCREEN,
            canFullScreen: true,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('toggleFullScreen toggles isFullScreen', function(assert) {
        const action = toggleFullScreen();

        const expectedAction = {
            type: ACTION_TOGGLE_FULLSCREEN,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('toggleTheatreMode toggles isFullScreen', function(assert) {
        const action = toggleTheatreMode();

        const expectedAction = {
            type: ACTION_TOGGLE_THEATRE_MODE,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('setTheatreMode is formatted correctly', function(assert) {
        const action = setTheatreMode(true);

        const expectedAction = {
            type: ACTION_SET_THEATRE_MODE,
            isTheatreMode: true,
        };

        assert.deepEqual(action, expectedAction);
    });
});
