import sinon from 'sinon';
import * as SettingsActions from 'actions/settings';

import { localStore } from 'tests/fakes/local-store.fake';
import { SITE_MINIPLAYER_ACTION } from 'analytics/analytics';

QUnit.module('actions | settings', function(hooks) {
    hooks.beforeEach(function() {
        this.analyticsTracker = {
            trackEvent: sinon.spy(),
        };

        this.getState = () => {
            return {
                analyticsTracker: this.analyticsTracker,
            };
        };
    });

    QUnit.test('enablePlayerPersistence', function(assert) {
        const dispatch = sinon.spy();
        const action = SettingsActions.enablePlayerPersistence();

        action(dispatch, this.getState);
        const dispatchedAction = dispatch.firstCall.args[0];

        // eslint-disable-next-line max-len
        assert.equal(dispatchedAction.type, SettingsActions.ACTION_SET_PERSISTENCE, 'should create an action of type SET_PERSISTENCE');
        assert.ok(localStore.get('persistenceEnabled'), 'persistenceEnabled in localStore is set true');
        assert.ok(dispatchedAction.value, 'should have a value of true');
        assert.ok(this.analyticsTracker.trackEvent.calledWith(SITE_MINIPLAYER_ACTION, sinon.match({
            action: 'persistence_enable',
        })), 'should track a `persistence_enable` event');
    });

    QUnit.test('disablePlayerPersistence', function(assert) {
        const dispatch = sinon.spy();
        const action = SettingsActions.disablePlayerPersistence();

        action(dispatch, this.getState);
        const dispatchedAction = dispatch.firstCall.args[0];

        // eslint-disable-next-line max-len
        assert.equal(dispatchedAction.type, SettingsActions.ACTION_SET_PERSISTENCE, 'should create an action of type SET_PERSISTENCE');
        assert.notOk(localStore.get('persistenceEnabled'), 'persistenceEnabled in localStore is set false');
        assert.notOk(dispatchedAction.value, 'should have a value of false');
        assert.ok(this.analyticsTracker.trackEvent.calledWith(SITE_MINIPLAYER_ACTION, sinon.match({
            action: 'persistence_disable',
        })), 'should track a `persistence_disable` event');
    });
});
