import { ACTION_UPDATE_STATS, ACTION_DISPLAY_STATS, updateStats,
         displayStats } from 'actions/stats';
import { DEFAULT_STATS } from 'state/stats';

QUnit.module('actions | stats', function() {
    QUnit.test('updateStats is formatted correctly', function(assert) {
        const action = updateStats(DEFAULT_STATS);

        const expectedAction = {
            type: ACTION_UPDATE_STATS,
            videoStats: DEFAULT_STATS,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('displayStats is formatted correctly', function(assert) {
        const action = displayStats(true);

        const expectedAction = {
            type: ACTION_DISPLAY_STATS,
            displayed: true,
        };

        assert.deepEqual(action, expectedAction);
    });
});
