import { ACTION_SET_MUTED_SEGMENTS, ACTION_SET_PREVIEWS, ACTION_SET_MARKERS,
         setMutedSegments, setPreviews, setMarkers } from 'actions/timeline-metadata';

QUnit.module('actions | timelineMetadata', function() {
    QUnit.test('setMutedSegments is formatted correctly', function(assert) {
        const mutedSegments = [
            {
                offset: 15,
                duration: 5,
            },
            {
                offset: 52,
                duration: 5,
            },
        ];

        const action = setMutedSegments(mutedSegments);

        const expectedAction = {
            type: ACTION_SET_MUTED_SEGMENTS,
            mutedSegments: mutedSegments,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('setPreviews is formatted correctly', function(assert) {
        const previews = {
            count: 0,
            lq: {
                width: 0,
                height: 0,
                rows: 0,
                cols: 0,
                URLs: [''],
            },
            hq: {
                width: 0,
                height: 0,
                rows: 0,
                cols: 0,
                URLs: [''],
            },
        };

        const action = setPreviews(previews);

        const expectedAction = {
            type: ACTION_SET_PREVIEWS,
            previews: previews,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('setMarkers is formatted correctly', function(assert) {
        const markers = [
            {
                info: '<strong>Druid</strong> vs Druid',
                startTime: 924.998,
                title: 'Match 1',
                thumbnail: {
                    imageURL: 'image url 1',
                    x: 0,
                    y: 0,
                    width: 0,
                    height: 0,
                    cols: 0,
                },
            },
            {
                info: '<strong>Druid</strong> vs Rogue',
                startTime: 1397,
                title: 'Match 2',
                thumbnail: {
                    imageURL: 'image url 1',
                    x: 0,
                    y: 0,
                    width: 0,
                    height: 0,
                    cols: 0,
                },
            },
        ];

        const action = setMarkers(markers);

        const expectedAction = {
            type: ACTION_SET_MARKERS,
            markers: markers,
        };

        assert.deepEqual(action, expectedAction);
    });
});
