import * as UIActions from 'actions/ui';

QUnit.module('actions | ui', function() {
    QUnit.test('setMiniPlayerMode', function(assert) {
        const action = UIActions.setMiniPlayerMode(true);

        assert.equal(action.type, UIActions.ACTION_SET_MINIPLAYER_MODE, 'should create an action of the correct type');
        assert.equal(action.value, true, 'should have the value that was passed');
    });

    QUnit.test('showMenu', function(assert) {
        const states = [
            UIActions.MENU_STATE_NONE,
            UIActions.MENU_STATE_SETTINGS,
            UIActions.MENU_STATE_EXTENSIONS,
        ];

        states.forEach(state => {
            const action = UIActions.showMenu(state);

            assert.equal(action.type, UIActions.ACTION_SHOW_SETTINGS_MENU,
                'should create an action of the correct type');
            assert.equal(action.value, state,
                'should have the value that was passed');
        });
    });

    QUnit.test('setUIDisplay', function(assert) {
        const showUI = true;
        const expectedAction = {
            type: UIActions.ACTION_SET_UI_DISPLAY,
            showUI,
        };
        assert.deepEqual(UIActions.setUIDisplay(true), expectedAction);
    });

    QUnit.test('showUIWithAutoHide', function(assert) {
        const expectedAction = {
            type: UIActions.ACTION_SHOW_UI_WITH_AUTO_HIDE,
        };
        assert.deepEqual(UIActions.showUIWithAutoHide(), expectedAction);
    });

    QUnit.test('hideUI', function(assert) {
        const expectedAction = {
            type: UIActions.ACTION_HIDE_UI,
        };
        assert.deepEqual(UIActions.hideUI(), expectedAction);
    });

    QUnit.test('hoveringOnUIElement', function(assert) {
        const expectedAction = {
            type: UIActions.ACTION_HOVERING_ON_UI_ELEMENT,
        };
        assert.deepEqual(UIActions.hoveringOnUIElement(), expectedAction);
    });

    QUnit.test('hoveringOffUIElement', function(assert) {
        const expectedAction = {
            type: UIActions.ACTION_HOVERING_OFF_UI_ELEMENT,
        };
        assert.deepEqual(UIActions.hoveringOffUIElement(), expectedAction);
    });

    QUnit.test('showVolumeSlider', function(assert) {
        const expectedAction1 = {
            type: UIActions.ACTION_SHOW_VOLUME_SLIDER,
            value: true,
        };
        const expectedAction2 = {
            type: UIActions.ACTION_SHOW_VOLUME_SLIDER,
            value: false,
        };
        assert.deepEqual(UIActions.showVolumeSlider(true), expectedAction1);
        assert.deepEqual(UIActions.showVolumeSlider(false), expectedAction2);
    });
});
