import * as UsherActions from 'actions/usher';

QUnit.module('actions | usher', function() {
    QUnit.module('setUsherParams', function() {
        QUnit.test('generates a random cachebuster parameter', function(assert) {
            const action = UsherActions.setUsherParams('backend', {});

            assert.equal(action.type, UsherActions.ACTION_SET_USHER_PARAMS);
            assert.deepEqual(Object.keys(action.params).sort(), ['p', 'player_backend']);
            assert.ok(action.params.p >= 0);
            assert.ok(action.params.p <= 9999999);
        });

        QUnit.test('ensure that player_backend is set correctly', function(assert) {
            const backend = 'backend';
            const action = UsherActions.setUsherParams(backend, {});

            assert.equal(action.type, UsherActions.ACTION_SET_USHER_PARAMS);
            assert.equal(action.params.player_backend, backend);
        });

        QUnit.test('selects only the whitelisted Usher override parameters', function(assert) {
            const whitelistedParams = [
                `${UsherActions.USHER_PREFIX}_allow_expired`,
                `${UsherActions.USHER_PREFIX}_force_format`,
                `${UsherActions.USHER_PREFIX}_force_geo`,
                `${UsherActions.USHER_PREFIX}_force_ip`,
                `${UsherActions.USHER_PREFIX}_force_node`,
                `${UsherActions.USHER_PREFIX}_force_node_password`,
                `${UsherActions.USHER_PREFIX}_force_cluster`,
                `${UsherActions.USHER_PREFIX}_godlike`,
                `${UsherActions.USHER_PREFIX}_no_cdn`,
                `${UsherActions.USHER_PREFIX}_any_field`,
            ];
            const params = whitelistedParams.reduce((ps, param) => {
                // eslint-disable-next-line no-param-reassign
                ps[param] = true;
                return ps;
            }, {});
            // this should not be part of the usher params
            params.nonPrefixedParam = true;

            const action = UsherActions.setUsherParams('backend', params);
            whitelistedParams.forEach((element, index) => {
                whitelistedParams[index] = element.substring(UsherActions.USHER_PREFIX.length);
            });

            assert.deepEqual(
                Object.keys(action.params).filter(key => key !== 'p' && key !== 'player_backend').sort(),
                whitelistedParams.sort()
            );
        });
    });

    QUnit.test('setUsherHostOverride returns expected object', function(assert) {
        const action = UsherActions.setUsherHostOverride('newhost');
        assert.deepEqual(action, {
            type: UsherActions.ACTION_SET_USHER_HOST_OVERRIDE,
            hostOverride: 'newhost',
        });
    });
});
