import * as VideoAPIActions from 'actions/video-api';

class MockVideo {
    constructor() {}
}

QUnit.module('actions | video-api', function() {
    QUnit.test('videoAPILoaded is formatted correctly', function(assert) {
        const video = new MockVideo();
        const action = VideoAPIActions.videoAPILoaded(video);

        const expectedAction = {
            type: VideoAPIActions.ACTION_LOAD_VIDEO_API,
            video,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('play is formatted correctly', function(assert) {
        const action = VideoAPIActions.play();

        const expectedAction = {
            type: VideoAPIActions.ACTION_VIDEO_API_PLAY,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('pause is formatted correctly', function(assert) {
        const action = VideoAPIActions.pause();

        const expectedAction = {
            type: VideoAPIActions.ACTION_VIDEO_API_PAUSE,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('automated pause is formatted correctly', function(assert) {
        const action = VideoAPIActions.automatedPause();

        const expectedAction = {
            type: VideoAPIActions.ACTION_AUTOMATED_PAUSE,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('changeVolume is formatted correctly', function(assert) {
        const newVolume = 5;
        const action = VideoAPIActions.changeVolume(5);

        const expectedAction = {
            type: VideoAPIActions.ACTION_VIDEO_API_CHANGE_VOLUME,
            volume: newVolume,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('mutePlayer is formatted correctly', function(assert) {
        const muted = true;
        const automated = true;
        const action = VideoAPIActions.mutePlayer(muted, automated);

        const expectedAction = {
            type: VideoAPIActions.ACTION_VIDEO_API_MUTE_PLAYER,
            muted,
            automated,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('changeBackend is formatted correctly', function(assert) {
        const backendType = 'backendtypename';
        const action = VideoAPIActions.changeBackend(backendType);

        const expectedAction = {
            type: VideoAPIActions.ACTION_VIDEO_API_CHANGE_BACKEND,
            backendType,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('submitVideoIssueReport is formatted correctly', function(assert) {
        const issueType = 'too many ads';
        const action = VideoAPIActions.submitVideoIssueReport(issueType);

        const expectedAction = {
            type: VideoAPIActions.ACTION_VIDEO_API_REPORT_VIDEO_ISSUE,
            issueType,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('changePlaybackRate is formatted correctly', function(assert) {
        const playbackRate = 2;
        const action = VideoAPIActions.changePlaybackRate(playbackRate);

        const expectedAction = {
            type: VideoAPIActions.ACTION_VIDEO_API_CHANGE_PLAYBACK_RATE,
            playbackRate,
        };

        assert.deepEqual(action, expectedAction);
    });

    QUnit.test('seek is formatted correctly', function(assert) {
        const seekTime = 100;
        const action = VideoAPIActions.seek(seekTime);

        const expectedAction = {
            type: VideoAPIActions.ACTION_VIDEO_API_SEEK,
            seekTime,
        };

        assert.deepEqual(action, expectedAction);
    });
});
