import { unitTest } from 'tests/utils/module';
import sinon from 'sinon';
import { waitFor } from 'tests/utils/waitFor';
import { ACTION_SET_WATCHPARTY_VOD, updateWatchPartyVod } from 'actions/watch-party';

unitTest('actions | watch-party', function() {
    QUnit.test('updateWatchPartyVod should update watchParty with normalized pubsub info', function(assert) {
        /* eslint-disable camelcase */
        const pubsubInfo = {
            wp_id: 'watchPartyId',
            vod_id: 'vodId',
            title: 'Something cool!',
            viewable: 'public',
            broadcast_type: 'highlight',
            increment_url: 'increment-url',
        };
        /* eslint-enable camelcase */

        const expectedWatchPartyInfo = {
            watchPartyId: pubsubInfo.wp_id,
            vodId: pubsubInfo.vod_id,
            title: pubsubInfo.title,
            viewable: 'public',
            broadcastType: 'highlight',
            incrementViewCountURL: pubsubInfo.increment_url,
        };
        const dispatch = sinon.spy();
        const setWatchPartySpy = dispatch.withArgs(sinon.match({
            type: ACTION_SET_WATCHPARTY_VOD,
        }));

        const action = updateWatchPartyVod(pubsubInfo);
        action(dispatch);

        return waitFor(() => setWatchPartySpy.called).then(() => {
            assert.deepEqual(
                setWatchPartySpy.firstCall.args[0],
                {
                    type: ACTION_SET_WATCHPARTY_VOD,
                    pubsubVodInfo: expectedWatchPartyInfo,
                }
            );
        });
    });
});
