import sinon from 'sinon';
import { unitTest } from 'tests/utils/module';
import { DfpCreativeService } from 'ads/dfp-creative-service';

unitTest('ads | dfp-creative-service', function(hooks) {
    hooks.beforeEach(function() {
        this.dfpCreativeService = new DfpCreativeService();
        this.creativeId = 12345;
        this.httpResponse = {
            // eslint-disable-next-line camelcase
            vast_xml_response: 'example vast xml response',
        };
        this.error = new Error('network error');

        this.httpsGetStub = sinon.stub(this.dfpCreativeService, '_httpsGet');
    });

    hooks.afterEach(function() {
        this.httpsGetStub.restore();
    });

    QUnit.test('can get VAST response', function(assert) {
        this.httpsGetStub.returns(Promise.resolve(this.httpResponse));

        return this.dfpCreativeService.getVastXmlResponse(this.creativeId).then(response => {
            assert.equal(response, this.httpResponse.vast_xml_response);
        });
    });

    QUnit.test('invalid response format will throw error', function(assert) {
        this.httpsGetStub.returns(Promise.resolve('not json'));

        return this.dfpCreativeService.getVastXmlResponse(this.creativeId).catch(() => {
            assert.ok(true);
        });
    });

    QUnit.test('no vast_xml_response field will throw error', function(assert) {
        this.httpsGetStub.returns(Promise.resolve({ foo: 'bar' }));

        return this.dfpCreativeService.getVastXmlResponse(this.creativeId).catch(() => {
            assert.ok(true);
        });
    });

    QUnit.test('https get fails will throw error', function(assert) {
        this.httpsGetStub.returns(Promise.reject(this.error));

        return this.dfpCreativeService.getVastXmlResponse(this.creativeId).catch(error => {
            assert.equal(error, this.error);
        });
    });
});
