import { MixpanelClient } from 'analytics/mixpanel';
import { unitTest } from '../../../utils/module';

unitTest('analytics | mixpanel', function(hooks) {
    hooks.beforeEach(function() {
        this.host = '//trackingendpoint.com';
        this.mixpanelClient = new MixpanelClient({
            token: 'faketoken',
            host: this.host,
        });
    });

    QUnit.test('trackEvent works with a payload that has a character out of range of 8bit ascii', function(assert) {
        // eslint-disable-next-line max-len
        const expectedData = 'data=eyJldmVudCI6ImV2ZW50TmFtZSIsInByb3BlcnRpZXMiOnsiY3JhenlTdHJpbmciOiLinJMgw6AgbGEgbW9kZSIsInRva2VuIjoiZmFrZXRva2VuIn19&ip=1';

        this.api.mock(`${this.host}/track?${expectedData}`, 200);

        try {
            this.mixpanelClient.trackEvent('eventName', { crazyString: '✓ à la mode' });
        } catch (e) {
            assert.ok(false);
        }

        assert.equal(this.api.calls().matched.length, 1);
    });
});
