import * as sentinel from 'analytics/sentinel';

QUnit.skip('analytics | sentinel', function() {
    QUnit.module('getSentinel', function() {
        QUnit.module('when Sentinel script is retrieved', function() {
            QUnit.test('when adblock is on, it should return true', function(assert) {
                const sentinelPromise = sentinel.getSentinel();
                const blockingEvent = new Event('sp.blocking');
                document.dispatchEvent(blockingEvent);
                return sentinelPromise.then(function(value) {
                    assert.equal(Twitch.sentinel.detect._result, true);
                    assert.equal(value, true);
                });
            });

            QUnit.test('when adblock is off, it should return false', function(assert) {
                const sentinelPromise = sentinel.getSentinel();
                const blockingEvent = new Event('sp.not_blocking');
                document.dispatchEvent(blockingEvent);
                return sentinelPromise.then(function(value) {
                    assert.equal(Twitch.sentinel.detect._result, false);
                    assert.equal(value, false);
                });
            });
        });

        QUnit.module('when Sentinel is not retrieved', function(hooks) {
            hooks.beforeEach(function() {
                // Sentinel no longer uses $.ajax, but instead uses a script element
                // When VP-1762 / VP-1373 are worked on, this will have to be taken into account
                // $.ajax.returns(Promise.reject());
            });

            QUnit.test('it should return "unknown"', function(assert) {
                const sentinelPromise = sentinel.getSentinel();
                return sentinelPromise.then(function(value) {
                    assert.equal(Twitch.sentinel.detect._result, 'unknown');
                    assert.equal(value, 'unknown');
                });
            });
        });
    });
});
