import { b64EncodeUnicode } from 'analytics/util';
import { unitTest } from 'tests/utils/module';

unitTest('analytics | util', function() {
    QUnit.test('returns same result as btoa if 8bit ascii string', function(assert) {
        const testString = 'the final countdown';
        assert.equal(b64EncodeUnicode(testString), btoa(testString));
    });

    QUnit.test('properly encodes string with out of range character', function(assert) {
        const testString = '✓ à la mode';
        const encodedValue = '4pyTIMOgIGxhIG1vZGU=';

        assert.equal(b64EncodeUnicode(testString), encodedValue);
    });
});
