import Errors from 'errors';
import ERROR_METADATA from 'error-metadata';
import keys from 'lodash/keys';

QUnit.module('error', function() {
    QUnit.test('getError returns correctly formed errors', function(assert) {
        keys(Errors.CODES).forEach(errorName => {
            const code = Errors.CODES[errorName];
            assert.deepEqual(
                Errors.getError(code),
                ERROR_METADATA[errorName],
                `getError on ${errorName} code return correct error`
            );
        });
    });

    QUnit.test('getError errors out if passed invalid code', function(assert) {
        const badErrorCode = 'abc';
        try {
            Errors.getError(badErrorCode);
        } catch (e) {
            assert.ok(e instanceof Error, 'throws error object');
            assert.equal(e.message,
                `Invalid error code ${badErrorCode}`,
                'error message is correct'
            );
        }
    });

    QUnit.test('getMessage returns correct messages on valid error codes', function(assert) {
        keys(Errors.CODES).forEach(errorName => {
            const code = Errors.CODES[errorName];
            assert.equal(
                Errors.getMessage(code),
                ERROR_METADATA[errorName].message,
                `getMessage on ${errorName} code return correct message`
            );
        });
    });

    QUnit.test('getMessage errors out if passed invalid code', function(assert) {
        const badErrorCode = 'abc';
        try {
            Errors.getMessage(badErrorCode);
        } catch (e) {
            assert.ok(e instanceof Error, 'throws error object');
            assert.equal(e.message,
                `Invalid error code ${badErrorCode}`,
                'error message is correct'
            );
        }
    });
});
