import { bakingBreadSafeBrowser } from 'experiments';

QUnit.module('experiments', function() {
    QUnit.module('bakingBreadSafeBrowser', function() {
        QUnit.test('non firefox browsers should be baking bread safe', function(assert) {
            // eslint-disable-next-line max-len
            const userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36';
            assert.ok(bakingBreadSafeBrowser(userAgent));
        });

        QUnit.test('firefox browsers above v45 should be baking bread safe', function(assert) {
            const userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0';
            assert.ok(bakingBreadSafeBrowser(userAgent));
        });

        QUnit.test('firefox browsers v45 and below should be baking bread unsafe', function(assert) {
            const userAgent = 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.1';
            assert.notOk(bakingBreadSafeBrowser(userAgent));
        });
    });
});
