import Player from 'player'; // eslint-disable-line no-unused-vars
import { waitFor } from 'tests/utils/waitFor';

QUnit.module('integration | captions', function(hooks) {
    hooks.beforeEach(function() {
        this.root = window.document.createElement('div');
        this.root.id = 'root';
        window.document.getElementById('qunit-fixture').appendChild(this.root);
    });

    QUnit.skip('can display caption data', function(assert) {
        new Twitch.Player('root', {
            flash: true,
        });
        const es = [
            {
                event: 'captions',
                data: {
                    format: 'eia608',
                    mode: 'pop-on',
                    rollUp: 0,
                    data: [
                        /* eslint-disable object-property-newline */
                        { row: 0, col: 0, char: 'L', style: 'white' },
                        { row: 0, col: 1, char: 'a', style: 'white' },
                        { row: 0, col: 3, char: 'n', style: 'white' },
                        { row: 0, col: 4, char: 'd', style: 'white' },
                        { row: 0, col: 5, char: 'o', style: 'white' },
                        /* eslint-enable object-property-newline */
                    ],
                },
            },
        ];

        // Fire first caption, to signal captions enabled
        window._BackendFlash_emitEvents('0', es);

        return waitFor(() => this.root.getElementsByClassName('js-control-cc').length > 0).
        then(() => {
            this.root.getElementsByClassName('js-control-cc')[0].click();

            // Fire our next caption event
            window._BackendFlash_emitEvents('0', es);

            return waitFor(() => this.root.getElementsByClassName('js-player-captions')[0].innerText !== '');
        }).
        then(() => {
            const $playerCaptions = this.root.getElementsByClassName('js-player-captions')[0];
            assert.equal($playerCaptions.innerText, 'Lando');
            assert.notEqual($playerCaptions.getAttribute('data-preset'), 'cyan-on-black');

            this.root.getElementsByClassName('js-menu-button-settings')[0].click();
            assert.equal(this.root.getElementsByClassName('js-menu')[0].getAttribute('data-open'), 'open');

            this.root.getElementsByClassName('js-cc-open-modal')[0].click();
            assert.equal(
                this.root.getElementsByClassName('js-cc-modal-container')[0].getAttribute('data-state'),
                'open'
            );

            this.root.getElementsByClassName('js-cc-preset[data-preset="cyan-on-black"]')[0].click();

            return waitFor(() => {
                return this.root.getElementsByClassName('js-cc-preset[data-preset="cyan-on-black"]')[0].
                    classList.
                    contains('js-cc-preset-selected');
            });
        }).
        then(() => {
            assert.equal(this.root.getElementsByClassName('js-player-captions')[0].style.color, 'rgb(0, 255, 255)');
            assert.equal(
                this.root.getElementsByClassName('js-player-captions')[0].style.backgroundColor,
                'rgb(0, 0, 0)'
            );
        }).
        then(() => {
            this.root.getElementsByClassName('js-cc-tab-text')[0].click();
            return waitFor(() => {
                return this.root.getElementsByClassName('js-cc-tab-text')[0].
                    classList.contains('player-tabs__item--active');
            });
        });
    });
});
