import Player from 'player'; // eslint-disable-line no-unused-vars
import { waitFor } from 'tests/utils/waitFor';

QUnit.module('integration | fullscreen', function(hooks) {
    hooks.beforeEach(function() {
        this.root = window.document.createElement('div');
        this.root.id = 'root';
        window.document.getElementById('qunit-fixture').appendChild(this.root);
        this.player = new Twitch.Player('root');
    });

    hooks.afterEach(function() {
        this.player.destroy();
    });

    QUnit.test('`fullscreenchange` fires when fullscreen button is clicked', function(assert) {
        assert.expect(2);

        function assertCb() {
            assert.ok(true);
        }

        this.player.addEventListener('fullscreenchange', assertCb);

        return waitFor(() => {
            return this.root.getElementsByClassName('qa-fullscreen-button')[0];
        }).
        then($fullscreenButton => {
            // emulate toggle on and off
            $fullscreenButton.click();
            $fullscreenButton.click();
            this.player.removeEventListener('fullscreenchange', assertCb);
        });
    });
});
