import sinon from 'sinon';
import Player from 'player'; // eslint-disable-line no-unused-vars
import * as sentinel from 'analytics/sentinel';

function createPlayer() {
    return new Twitch.Player('root', {
        channel: 'monstercat',
    });
}

QUnit.module('integration | sentinel', function(hooks) {
    hooks.beforeEach(function() {
        const $root = window.document.createElement('div');
        $root.id = 'root';
        window.document.getElementById('qunit-fixture').appendChild($root);

        // In order to prevent making an actual request for the sentinel file, stub out createElement
        // This way, when a script element is created with it, nothing happens
        sinon.stub(sentinel, 'getSentinel');
        sentinel.getSentinel.returns(Promise.resolve());
    });

    hooks.afterEach(function() {
        sentinel.getSentinel.restore();
        if (window.Twitch.sentinel) {
            delete(window.Twitch.sentinel);
        }
    });

    QUnit.test('it should call getSentinel once if Twitch.sentinel is not present', function(assert) {
        // Remove Twitch.sentinel, just in case
        delete(window.Twitch.sentinel);
        createPlayer();
        assert.equal(sentinel.getSentinel.calledOnce, true);
    });

    QUnit.test('it should not call getSentinel if Twitch.sentinel is present', function(assert) {
        // Fake sentinel object
        window.Twitch.sentinel = { detect: {} };
        createPlayer();
        assert.equal(sentinel.getSentinel.called, false);
    });
});
