import { getI18N, missingKeyHandler } from 'lang/i18n';
import * as i18next from 'tests/fakes/i18next.fake';
import { unitTest } from 'tests/utils/module';

unitTest('lang | i18n', function() {
    QUnit.test('getI18N returns with uppercase country code', function(assert) {
        return getI18N('en-us').then(i18n => {
            assert.equal(i18n.langCode, 'en-US');
        });
    });

    QUnit.test('getI18N for traditional chinese returns traditional chinese translator', function(assert) {
        return getI18N('zh-tw').then(i18n => {
            assert.equal(i18n.shortCode, 'zh');
            assert.equal(i18n.langCode, 'zh-TW');
        });
    });

    QUnit.test('getI18N without country code looks it up and returns it', function(assert) {
        return getI18N('en').then(i18n => {
            assert.equal(i18n.shortCode, 'en');
            assert.equal(i18n.langCode, 'en-US');
        });
    });

    QUnit.test('getI18N w/o country code for languages with multiple countries respects overrides', function(assert) {
        return getI18N('zh').then(i18n => {
            assert.equal(i18n.shortCode, 'zh');
            assert.equal(i18n.langCode, 'zh-CN');
        });
    });

    QUnit.test('has handler for missing translation keys, and will call that handler', function(assert) {
        return getI18N('en-us').then(() => {
            assert.equal(i18next.missingKeyHandler, missingKeyHandler);
            assert.equal(i18next.saveMissing, true);
        });
    });
});
