import { PlayerResizeManager } from 'player-resize-manager';
import * as PlayerDimensionsActions from 'actions/player-dimensions';
import { init as initStore } from 'state';
import sinon from 'sinon';
import { unitTest } from 'tests/utils/module';
import { waitFor } from 'tests/utils/waitFor';

unitTest('player-resize-manager', function(hooks) {
    const left = '100px';
    const top = '200px';
    const width = '300px';
    const height = '400px';

    const resizeLeft = '1px';
    const resizeTop = '2px';
    const resizeWidth = '3px';
    const resizeHeight = '4px';

    hooks.beforeEach(function() {
        this.store = initStore();
        this.playerResizeManager = new PlayerResizeManager(this.store);

        this.testElement = document.createElement('div');
        this.testElement.id = 'root';
        this.testElement.style.left = left;
        this.testElement.style.top = top;
        this.testElement.style.width = width;
        this.testElement.style.height = height;
    });

    QUnit.module('will dispatch player dimensions initially on observe call', function() {
        QUnit.test('will call dispatch.', function(assert) {
            sinon.spy(this.store, 'dispatch');
            this.playerResizeManager.observe(this.testElement);
            this.playerResizeManager.resizeObserver._triggerResize();

            return waitFor(() => this.store.dispatch.called === true).then(() => {
                assert.ok(this.store.dispatch.calledWith({
                    type: PlayerDimensionsActions.ACTION_UPDATE_PLAYER_DIMENSIONS,
                    playerDimensions: {
                        left: left,
                        top: top,
                        width: width,
                        height: height,
                    },
                }));
            });
        });
        QUnit.test('will dispatch new dimensions when player is resized', function(assert) {
            sinon.spy(this.store, 'dispatch');
            this.playerResizeManager.observe(this.testElement);
            this.playerResizeManager.resizeObserver._triggerResize();

            this.playerResizeManager.resizeObserver._observeElements[0] = {
                contentRect: {
                    left: resizeLeft,
                    top: resizeTop,
                    width: resizeWidth,
                    height: resizeHeight,
                },
            };

            this.playerResizeManager.resizeObserver._triggerResize();

            return waitFor(() => this.store.dispatch.called === true).then(() => {
                assert.ok(this.store.dispatch.calledWith({
                    type: PlayerDimensionsActions.ACTION_UPDATE_PLAYER_DIMENSIONS,
                    playerDimensions: {
                        left: resizeLeft,
                        top: resizeTop,
                        width: resizeWidth,
                        height: resizeHeight,
                    },
                }));
            });
        });
    });
});
